/* 
 *  MPEGDec.cpp  -  MPEG audio decoding
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include <memory.h>
#include "MPEGDec.h"
#include <windows.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMPEGDec::CMPEGDec()
{

}

CMPEGDec::~CMPEGDec()
{

}
int CMPEGDec::Start()
{
	in_ptr     =0;
	frame_size =0;
	if( (decoder=CreateAMPDecoder()) ){
		decoder->Init();
		decoder->setSource(this);
		return 1;
	}
	else
		return 0;
}

int CMPEGDec::Stop()
{
	return 0;
}

// Audio decoder data reader
int CMPEGDec::read(void *buffer, int bytes){
	int bytes_to_read;

	if(bytes > (frame_size - in_ptr) ){
		bytes_to_read = frame_size - in_ptr;
	}
	else
		bytes_to_read = bytes;
	memcpy(buffer, &frame_data[in_ptr], bytes_to_read);
	in_ptr += bytes_to_read;

	return bytes_to_read;
}

int CMPEGDec::decodeFrame(ui8 *pcm_samples, ui8 *frame_data, ui32 frame_size)
{
	AMPStreamInfo pasi;
	int i;
	in_ptr           = 0;
	this->frame_size = frame_size;
	this->frame_data = frame_data;
  bool bSuccess;

  try
  {
	  decoder->Reset();
	  decoder->ReadHeader();

	  decoder->getStreamInfo(&pasi);
	  if(pasi.fStereo)
		  decoder->setDestination((short *)pcm_samples);
	  else
		  decoder->setDestination(temp_buffer);


	  // Convert mono to stereo

    if(decoder->DecodeFrame())
    {
      if(!pasi.fStereo)
        for(i=0; i<FRAME_SAMPLES*2; i++)
          ((short *)pcm_samples)[i] = temp_buffer[i>>1];
        bSuccess = true;
    }
    else
      bSuccess = false;    
  }
  catch(...)
  {
    OutputDebugString("CMPEGDec::decodeFrame() - Mpeg decoder generated unhandled expection.\n");
  }

  return bSuccess;
}
