
/* 
 *  Audio.h
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#if !defined(AFX_AUDIO_H__8B6E2FE2_9AC7_11D3_8C3D_00000100CF13__INCLUDED_)
#define AFX_AUDIO_H__8B6E2FE2_9AC7_11D3_8C3D_00000100CF13__INCLUDED_


#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\Demux\Demux.h"
#include ".\Resampler\Resampler.h"
#include ".\AudFrameBuffer.h"
#include "A52\CA52Dec.h"	
#include "MPEG\MPEGDec.h"
#include ".\Utils\AudioCompressor.h"

#define  AUDIO_BUFFER_SIZE 0x80000
#define  PCM_BUFFER_SIZE 96000
#define AC3_PCM_SAMPLES 1536 //2 channels * 16 bit * 1536 samples
#define   PCM_1SECOND_SIZE 256000
#define   SEQUENCE_END_CODE       0x1B7
#define   AC3_SYNC_WORD    0x0B77
#define   MPEG_SYNC_WORD   0x0FFF



// Format defines
#define  AC3_FORMAT  0
#define  MPEG_FORMAT 1

enum AudioFormat{ Ac3=0, MpegAudio , Lpcm, Dts, Sdds, UNknown};

//Audio start options
#define NO_AUDIO		0
#define DSC				  1
#define DO_AUDIO		2
#define AUDIO_PREVIEW     4
#define AUDIO_DONT_NORMALIZE 8

#ifndef ABS
#define ABS(x)         ( (x>0)? x: -x)
#endif

#define CLK_ERROR(x,y) (ABS( (i64)x - (i64)y) )
#define CLK_THRESHOLD       250
#define CLK_THRESHOLD_SPAN  1000
struct TTimeSpan{
	i64  start;
	i64  end;
};

struct PESdata{
	PESinfo         pInfo;
     ui8           *data;
    ui32            datasize;
};

#define MAX_AUDIO_TRACKS 16
struct TAudioInfo
{
  AudioFormat format;
  int bit_rate;
  int channels;
  int subwoofer;
  int sample_rate;
};


typedef struct tagAudioTrack
{
  ui8         nStreamId;    // Indicates stream Id
  ui8         nSubStreamId; // Indicates substream Id
} TAudioTrack;

#if 0
typedef struct tagAudioIds
{
  TAudioTrack vTracks[MAX_AUDIO_TRACKS];
  int   nCount;
  int   nSelected;
} TAudioTracks;
#endif 

struct TReadSpanRunState{
	bool    firstTime;
	bool    frame_in_course;
	bool    header_in_course;

	ui64    lastSCR;
	ui32    lastPackBytes;
	ui32    lastMuxrate;

	TAudFramePresInfo frame_pInfo;

	ui32    frame_size;
	ui32    frame_remaining_bytes;
	ui8     frame_data[65000];
	ui32    out_ptr;
	ui32    in_ptr;

	 i64    delta;
	PESdata PES;
};

// Maximum range 1200 = +/- 12 dB
#define TAUDIOPROPERTIES_MCHANNEL_MAX_RANGE 1200 
struct TAudioProperties
{
  // The following properties can be altered during the conversion.
  bool drc;                 // The Dynamic Range Compression is on
  int  drc_value;           // Value of the Dynamic Range Compression
  bool multichannel_volume; // Multichannel audio is being modified in volume
  int  rear;                // Values for multichannel audio volumes
  int  front;
  int  center;
  bool dolby_surround_downmix;
  bool normalize;           // Is normalizing
  int  normalize_value;     // Value to normalize
  TAudioTrack sAudioTrack;  // Track to play
};

struct TFrameSize
{
	ui16 bit_rate;
	ui16 frm_size[3];
};



class Audio: public CDemux, public CDataSource
{

public:
  // Returns basic info of the current stream. Returns NULL if the info is not available.
  TAudioInfo * GetAudioInfo();

  // This must be serialize with calls to GetSamples()
  void SetTrack(TAudioTrack *pAudioTrack);

	int GetSamples(int frame, short **buffer, int nSamples);
  void GetAudioProperties(TAudioProperties *pAudProps)
  {
    *pAudProps = m_sAudioProperties;
  }
  void SetAudioProperties(TAudioProperties *pAudProps)
  {
    m_sAudioProperties = *pAudProps;
  }

  // This is the sample rate of the input
  // audio. We don't allow multiple streams
  // with different sample rates. Unlikely to happen though.
	int sampleRate;


	int GetAudioDSC(i64 PTS, i64 videoStreamPos);
	int GetAudio();

	int Stop();
	int Start(char* inputFile, int audioMode);
	bool Start(int out_sFreq, int audioMode, TAudioProperties *pAudProps );

	int SetAudioMode(int audioMode); 
  
  AudioFormat GetFormat() { return m_nFormat; }

	int read(char *buffer);

  bool Init( LPTWorkingMism pMismInfo );
	Audio();
	~Audio();
  
private:
  bool SetTrackIdsAndFormat(TAudioTrack *pTrack);
  // Audio format in progress
  AudioFormat m_nFormat;
  // Stream in progress
  ui8 m_nSubStreamID;
  ui8 m_nStreamID;

	int decodeFrame( CAudioFrame *frame ,short *pcm_samples);
	int ParseHeader(ui32 headers_found);
	int FindHeader(ui32 headers_found);
	int RetrieveFrameData();
	int ReadSpanInit();
	void ParseFrameData();

  //bool GetTrackProperties(TAudioTrack *pTrack);
  bool GetPropertiesFromFrame(AudioFormat nFormat, ui8* pFrame, TAudioInfo *pTrackInfo);
  void Normalize(i16 *pData, ui32 nDataSize, float gain);

	CA52Dec  *m_pA52Dec;
	CMPEGDec *MPEGDec;

	CAudioCompressor AC;

  TAudioProperties m_sAudioProperties;

  bool  m_bIsPreview;
  bool  m_bDontNormalize;
	int                 ReadSpan( TTimeSpan *span, i64 time);
	TReadSpanRunState   read_state;

	int audioMode;
	

  bool m_bAudioInfoIsValid;
  TAudioInfo    m_sAudioInfo;
	CAsyncBuffer *decoded_samples_buffer;
	CAsyncBuffer *ResamplerBuffer;
	CAsyncBuffer *compressed_samples_buffer;
	CAsyncBuffer *destination_buffer;

	CResampler          *resampler;
	CAudFrameBuffer     *frameFIFO;

	bool firstPTSfound;
	i64 prevSysClk;

	//read() variables. Cannot be static because they can't be shared
	//                  between object instances
    int   eof_flag;
	bool  frame_in_progress;
	ui32  fip_remaining_bytes;
	short temp_decoded_frame[1536*2];
	ui32  temp_decoded_ptr;
	 i64  aud_clk;
    ui32  tot_n_samples;
	// GetAudioDSC()
	i64 firstPTS;

	// ParseHeader()
	int header_pos;
	ui8 hdr2, hdr3, mpeg_header[3];

	// MPEG audio stuff
	ui8  bit_rate_index;
  ui8  mode;
	ui32 bitrate;
	ui32 mpeg_layer;
	ui8  sampling_frequency;
	ui8  padding_bit;
	ui32 N;


	bool   justStarted;
	bool   stopDecoder;
	bool   decoderStopped;
	char   buffer[AUDIO_BUFFER_SIZE];		
	FILE			*hOutputFile;
};

#endif // !defined(AFX_AUDIO_H__8B6E2FE2_9AC7_11D3_8C3D_00000100CF13__INCLUDED_)
