// AudFrameBuffer.cpp: implementation of the CAudFrameBuffer class.
//
//////////////////////////////////////////////////////////////////////

#ifndef NULL
#define NULL 0
#endif 

#include "AudFrameBuffer.h"
#include <memory.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAudioFrame::CAudioFrame(ui8               *data,
						 ui32               datasize,
                         TAudFramePresInfo *pInfo, 
			             CAudioFrame       *next, 
			             CAudioFrame       *previous){
	if(this->data = new ui8[datasize] ){
		memcpy( this->data, data, datasize );
		this->datasize = datasize;
	}
	else{
		this->data = NULL;
		datasize   = 0;
	}
	mpeg_layer = 0;
	memcpy( &this->pInfo, pInfo, sizeof(TAudFramePresInfo) );
	this->next     = next;
	this->previous = previous;

	
}
CAudioFrame::~CAudioFrame(){
	if(data)
		delete data;
}
CAudFrameBuffer::CAudFrameBuffer()
{
	this->firstFrame = NULL;
	this->lastFrame  = NULL;
		n_frames       = 0;
}

CAudFrameBuffer::~CAudFrameBuffer()
{
  RemoveAllFrames();
}

void CAudFrameBuffer::RemoveAllFrames()
{
  CAudioFrame *temp;
  while(lastFrame!=NULL)
  {
    temp = lastFrame->previous;
    delete lastFrame;
    lastFrame = temp;
  }
  this->firstFrame = NULL;
  this->lastFrame  = NULL;
}

int CAudFrameBuffer::AddFrame(ui8 *data, ui32 datasize, TAudFramePresInfo *pInfo)
{
	CAudioFrame *temp;

	if( lastFrame==NULL && firstFrame==NULL)
		firstFrame=lastFrame= new CAudioFrame(data, datasize , pInfo, NULL, NULL);
	else{
		temp = lastFrame;
		// create new frame
		lastFrame = new CAudioFrame(data, datasize , pInfo, NULL, temp);
		temp->next = lastFrame;
		if(lastFrame)
			lastFrame->previous = temp;
	}
	n_frames++;
	
	return 1;
}

int CAudFrameBuffer::RemoveFirstFrame()
{
	CAudioFrame *temp;
	if(firstFrame){
		if(!firstFrame->next)
			lastFrame = NULL;
		temp = firstFrame->next;
		delete firstFrame;
		firstFrame = temp;
		if(firstFrame)
			firstFrame->previous=NULL;
		n_frames--;
		return 1;
	}
	else return 0;
}

int CAudFrameBuffer::RemoveFrame(CAudioFrame *frame)
{
	CAudioFrame *previous, *next;
	if(frame){
		previous = frame->previous;
		    next = frame->next;

		delete frame;

		if(previous)
			previous->next = next;
		else //previous was null. The deleted item was the first item. Update firstFrame
			firstFrame = next;

		if(next)
			next->previous = previous;
		else //next was null. The deleted item was the last item. Update lastFrame
			lastFrame = previous;

		n_frames--;
	
		return 1;
	}
	return 0;
}
