#ifndef A52DEC_H
#define A52DEC_H

#include "..\..\FlasKTypes.h"

extern "C"
{
  #include "a52.h"
}




class CA52Dec
{
public:
  // SyncInfo returns the number of bytes of the frame in the buffer. 0 if no possible frame
  int SyncInfo( ui8 *buf, int *nChannels, bool *bLfe, int *nSampleRate, int *nBitRate );
  void SetProperties(bool bProLogic, bool bModifyVolume, int nRange, int nCenter, int nFront, int nRear);
	int decodeFrame( ui8 *pcm_samples, ui8 *frame_data, ui32 frame_size);
	char sBitRate[256];
	CA52Dec();
	~CA52Dec();
	int read(char *buffer);
	char sAudioMode[256];
	char sSampleRate[256];
	int sampleRate;
	void Initialize_Buffer();
	int decodeFrame(short *buffer);
	int End();
	int Init();

private:

  int16_t Convert (int32_t i) // Converts IEEE floating point format
  {
    if (i > 0x43c07fff)
      return 32767;
    else if (i < 0x43bf8000)
      return -32768;
    else
      return i - 0x43c00000;
  };

  bool m_bInitialized;

  a52_state_s *m_pState;

};


#endif