/* 
 *  CA52Dec.cpp 
 *
 *	Copyright (C) Alberto Vigata - October 2001
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#include <memory.h>
#include <math.h>
#include "CA52Dec.h"
#include "debug.h"

//////////////////////////////////////////////////////////////////////
// CA52Dec Class
//////////////////////////////////////////////////////////////////////
#define FRAME_SIZE 256*6*4

const sample_t g_nA52Level = 32767.0;


CA52Dec::CA52Dec()
{

/*  m_gainfront   = 1;
  m_gaincenter  = 1;
  m_gainrear    = 1;
  
  m_dolby_surround = 0;
  m_do_normalize   = 0;
  m_do_multichannelvolume = 0;
	initialized = false;*/
  m_bInitialized = false;
}

CA52Dec::~CA52Dec()
{
}

static float CalculateAmp(int nRange, int value )
{
  float dBAmp =  (float)value / 100.0f;
  dBAmp = dBAmp / 20;
  return (float)pow( 10, dBAmp );
}

void CA52Dec::SetProperties(bool bProLogic, 
                            bool bModifyVolume, 
                            int  nRange, 
                            int  nCenter, 
                            int  nFront, 
                            int  nRear)
{
/*  m_dolby_surround = bProLogic ? 1 : 0;
  m_do_multichannelvolume = bModifyVolume ? 1 : 0;
  m_gainfront = CalculateAmp( nRange, nFront );
  m_gaincenter= CalculateAmp( nRange, nCenter );
  m_gainrear = CalculateAmp( nRange, nRear );*/
}

int CA52Dec::Init()
{
	if(!m_bInitialized){
	  m_pState = a52_init(0);
		m_bInitialized = true;
	}
	return 1;
}

// Table to translate a52lib flags into number of channels
static a52lib_channelnum[] = { 1, 1, 2, 3, 3, 4, 4, 5, 
                               1, 1, 2, 1, 1, 1, 1, 1 };

int CA52Dec::SyncInfo( ui8 *buf, int *nChannels, bool *bLfe, int *nSampleRate, int *nBitRate )
{
  bool bSuccess = buf && nChannels && bLfe && nSampleRate && nBitRate;
  int  nFrameBytes;
  
  if( bSuccess )
  {
    int nFlags;

    if( nFrameBytes = a52_syncinfo( (uint8_t *)buf, &nFlags, nSampleRate, nBitRate ) )
    {
      *nChannels = a52lib_channelnum[ nFlags&A52_CHANNEL_MASK ];
      *bLfe = nFlags&A52_LFE >0;
    }
    else
      bSuccess = false;
  }

  return bSuccess ? nFrameBytes : 0;
}

int CA52Dec::End()
{

	return 1;
}


int CA52Dec::decodeFrame( ui8 *pcm_samples, ui8 *frame_data, ui32 frame_size)
{

  short *buffer = (short *)pcm_samples;

  int nFlags = A52_STEREO | A52_ADJUST_LEVEL;
  sample_t fLevel = 1;


  // a52_frame initialises the decoding of the frame
  // returns <> 0 if error
  if ( a52_frame( m_pState, (uint8_t *)frame_data, &nFlags, &fLevel, 384 ) )
  {
    // reset outout samples
    memset(buffer, 0, FRAME_SIZE );
    DBG_STR((str, "CA52Dec::decodeFrame - frame is not valid. Muting\n"))
  }
  else // a52_frame ok. Decode blocks
  {
    for (int i = 0; i < 6; i++) 
    {
		    if (a52_block (m_pState))
        {
          // reset outout samples
          memset(buffer, 0, FRAME_SIZE );
          DBG_STR((str,"CA52Dec::decodeFrame - block is not valid. Muting\n"))
          break;
        }
        else
        {
          int32_t *pLeft, *pRight;
          pLeft  = (int32_t *) a52_samples( m_pState );
          pRight = pLeft + 256;

          // Convert to integer
          for(int j=0; j<256; j++)
          {
            *buffer++ = (short) Convert( *pLeft++ );
            *buffer++ = (short) Convert( *pRight++ );
          }
        }
    }
  }

	return FRAME_SIZE;

}
