/* 
 *  AsyncBuffer.cpp 
 *
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

// AsyncBuffer.cpp: implementation of the CAsyncBuffer class.
//
//////////////////////////////////////////////////////////////////////

#include "AsyncBuffer.h"
#include <malloc.h>
#include <stdio.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//Reads arbitrary bytes from a source that gives a fixed number
// of bytes 
CAsyncBuffer::CAsyncBuffer(CDataSource *src, int inputLenght, int bufferFillness)
{
	CAsyncBuffer::source=src;
	CAsyncBuffer::inputLenght=inputLenght;
		     maxInputLength = inputLenght;
	   this->bufferFillness = bufferFillness;
	BufferSize=maxInputLength*bufferFillness*2;
	Buffer= (char *)malloc(BufferSize);
	BufferTop=BufferPtr=0;
}

int CAsyncBuffer::ReadBuffer(char **outData, int nItems)
{
	int i,j,val;
	
	if( (BufferTop - BufferPtr) < nItems ){
			//There are some samples left at the top of the buffer
			for(i=BufferPtr,j=0; i<BufferTop; i++,j++){
				Buffer[j]=Buffer[i];
			}
			BufferPtr=0;
			BufferTop=j;
			val=1;
			while( (BufferTop < maxInputLength* bufferFillness) &&  val){
					inputLenght=val=source->read(&Buffer[BufferTop]);
					BufferTop += inputLenght;
			}
	}
	*outData=&Buffer[BufferPtr];
	BufferPtr+=nItems;
	return inputLenght;
}

CAsyncBuffer::~CAsyncBuffer()
{
	free(Buffer);
}
