/* 
 *  VideoSequenceCompressor.h
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#ifndef f_VIDEOSEQUENCECOMPRESSOR_H
#define f_VIDEOSEQUENCECOMPRESSOR_H

#include <afxtempl.h>
#include <vfw.h>
#include <Msacm.h>

class TVideoCodecInfo
{
public:
  TVideoCodecInfo()
  { m_nSettingsSize = 0;
    m_pSettings = m_pSettings2nd = m_pSettings1st = 0; }

  ~TVideoCodecInfo() 
  { 
    if(m_pSettings) delete []m_pSettings;
    if(m_pSettings1st) delete []m_pSettings1st;
    if(m_pSettings2nd) delete []m_pSettings2nd;
  }
  DWORD GetSettingsSize(){ return m_nSettingsSize; }
  PBYTE GetSettings() { return m_pSettings; }
  PBYTE GetSettings1st() { return m_pSettings1st; }
  PBYTE GetSettings2nd() { return m_pSettings2nd; }
  void SetSettings( PBYTE settings, DWORD size ) 
  {
    if(m_pSettings) delete []m_pSettings;
    m_nSettingsSize = size;
    m_pSettings = new BYTE[size];
    memcpy( m_pSettings, settings, size );
  }
  void SetSettings1st( PBYTE settings, DWORD size ) 
  {
    if(m_pSettings1st) delete []m_pSettings1st;
    m_nSettingsSize = size;
    m_pSettings1st = new BYTE[size];
    memcpy( m_pSettings1st, settings, size );
  }
  void SetSettings2nd( PBYTE settings, DWORD size ) 
  {
    if(m_pSettings2nd) delete []m_pSettings2nd;
    m_nSettingsSize = size;
    m_pSettings2nd = new BYTE[size];
    memcpy( m_pSettings2nd, settings, size );
  }

  void operator=( const TVideoCodecInfo &in )
  {
    hic = in.hic;
    fccHandler = in.fccHandler;
    wcscpy( szName, in.szName );
    wcscpy( szDescription, in.szDescription );
    wcscpy( szDriver, in.szDriver );
    dwSupportedFormats = in.dwSupportedFormats;
    m_nSettingsSize = in.m_nSettingsSize;
    
    if( in.m_nSettingsSize ) {
      SetSettings( in.m_pSettings, in.m_nSettingsSize );
      SetSettings1st( in.m_pSettings1st, in.m_nSettingsSize);
      SetSettings2nd( in.m_pSettings2nd, in.m_nSettingsSize );
    }
  }

  HIC   hic;
  DWORD fccHandler; 
  WCHAR szName[16]; 
  WCHAR szDescription[128]; 
  WCHAR szDriver[128]; 
  DWORD dwSupportedFormats;
  DWORD m_nSettingsSize;
  PBYTE m_pSettings;
  PBYTE m_pSettings1st;
  PBYTE m_pSettings2nd;
}; 


class VideoSequenceCompressor {
public:
	bool GetInstalledCodecs();
	bool InitVideoCompressor( DWORD fccHandler, HIC hic, int width, int heigth, int rate, int scale,
                            DWORD dwInFccHandler, int nInBitCount,
                            PBYTE settings=NULL, long settingssize=0);
  bool DeInitVideoCompressor();
public:
  bool CloseCompressors();


  CArray< TVideoCodecInfo, TVideoCodecInfo & > m_vVideoCodecList;
  CArray< TVideoCodecInfo, TVideoCodecInfo & > m_vInstalledCodecList;

  VideoSequenceCompressor();
  ~VideoSequenceCompressor();

	bool CodecIsInstalled( DWORD fccHandler, int *idx );  
  bool EnumerateVideoCodecs(int width, int height);

  void init(HIC hic, BITMAPINFO *pbiInput, BITMAPINFO *pbiOutput, long lQ, long lKeyRate);
  void setDataRate(long lDataRate, long lUsPerFrame, long lFrameCount);
  void start();
  void dropFrame();
  void *packFrame(void *pBits, bool *pfKeyframe, long *plSize);
  void finish();
  BITMAPINFOHEADER* GetOutputFormat();
  int GetOutputFormatSize();

	bool isSequenceIntelligent() {
		return !!(dwFlags & VIDCF_COMPRESSFRAMES);
	}

	long getMaxSize() {
		return lMaxPackedSize;
	}

private:
	HIC			hic;
	DWORD		dwFlags;
	BITMAPINFO	*pbiInput, *pbiOutput;
	char		*pOutputBuffer, *pPrevBuffer;
	long		lFrameNum, lKeyRate, lQuality;
	long		lKeyRateCounter;
	long		lMaxFrameSize;
	long		lMaxPackedSize;
	bool		fCompressionStarted;
	long		lSlopSpace;

	void		*pConfigData;
	int			cbConfigData;
};

#endif
