/* 
 *  StateManager.h
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#ifndef f_STATEMANAGER_H
#define f_STATEMANAGER_H

#include <afxtempl.h>
#include <vfw.h>
#include <Msacm.h>
#include "videosequencecompressor.h"
#include "audiocompressor.h"

// This class manages, the storage
//  of the state of the different codecs
class CStateManager
{
public:


  CStateManager(){ m_pBuf = NULL; };
  ~CStateManager(){ if(m_pBuf) delete []m_pBuf; };


  bool  SetWfx( WAVEFORMATEX * wfx, int wfxSize ) 
  {
    m_wfx.SetSize( wfxSize );
    memcpy( m_wfx.GetData(), wfx, wfxSize );
  return true;
  }
  int   GetWfxSize(){ return m_wfx.GetSize(); }
  DWORD GetFccHandler(){return m_video.fccHandler; }

  void SetVideoUncompressed( long dwSupportedFormats )
  {
    m_video.fccHandler = 0;
    m_video.dwSupportedFormats = dwSupportedFormats;
  }
  void SetVideoCodec( TVideoCodecInfo &vidc ) { m_video = vidc; }
  int   GetVidSupportedFormats() { return m_video.dwSupportedFormats; };
  HACMDRIVERID GetAcmDriverID(){ return m_hadid; };
  HIC   GetHic(){ return m_video.hic;}

//  void SetFccHandler(DWORD fccHandler){((TStateHeader *)m_pBuf)->fccHandler= fccHandler; };
//  void SetVidSupportedFormats(int nSupported){((TStateHeader *)m_pBuf)->nSupportedFormats= nSupported; };
  void SetAcmDriverID(HACMDRIVERID hadid){m_hadid= hadid; };
//  void SetHic(HIC hic){ ((TStateHeader *)m_pBuf)->hic = hic; }
  TVideoCodecInfo *GetVideo(){ return &m_video; }
  CWaveFormatEx &GetCWfx(){ return m_wfx; }
  WAVEFORMATEX *GetWfx(){ if(GetWfxSize()) return m_wfx.Get(); 
                          else return NULL; };

private:
  TVideoCodecInfo m_video;
  CWaveFormatEx m_wfx;
  HACMDRIVERID m_hadid;
  PBYTE m_pBuf;
};



#endif
