// SettingsManager.h: interface for the CSettingsManager class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SETTINGSMANAGER_H__B471FDE2_2D3A_439F_8D3A_80400824D089__INCLUDED_)
#define AFX_SETTINGSMANAGER_H__B471FDE2_2D3A_439F_8D3A_80400824D089__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "videosequencecompressor.h"
#include "audiocompressor.h"


#define SETTINGS_VERSION 0x00106600
//////////////////////////////
// This class manages our settings layout
//  in a memory block
//
//  layout:
//
//  long setver   - settings version
//  long size     - total size of the block
//  long fourCC   - selected video codec
//  long HADID    - selected audio codec
//  long wfxsize  - size of following waveformatex struc
//  [wfxsize bytes] wfx - wfx struct
//
//  ------------------ video codec settings section
//  long vidcodnum  - number of video codec settings
//  ..iteration of:
//  long fourCC
//  long settingssize
//  [settingssize bytes] settings
//  [settingssize bytes] settings_secondpass
class CSettingsManager  
{
public:
  CSettingsManager();
  virtual ~CSettingsManager();
  bool CreateBlock( PBYTE &Block, long &BlockSize, DWORD fourcc, DWORD hadid, CWaveFormatEx &wfx, CArray< TVideoCodecInfo, TVideoCodecInfo & > &vidarray );
  bool CreateFromBlock(  PBYTE m_pBlock, long m_nBlockSize, DWORD &fourcc, DWORD &hadid, CWaveFormatEx &wfx, CArray< TVideoCodecInfo, TVideoCodecInfo & > &vidarray );
private:
  PBYTE m_pBlock;
  long m_nBlockSize;

};

#endif // !defined(AFX_SETTINGSMANAGER_H__B471FDE2_2D3A_439F_8D3A_80400824D089__INCLUDED_)
