// SettingsManager.cpp: implementation of the CSettingsManager class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "SettingsManager.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSettingsManager::CSettingsManager()
{
  m_pBlock = NULL;
}

CSettingsManager::~CSettingsManager()
{
  if(m_pBlock) delete []m_pBlock;
}
//////////////////////////////
// This class manages our settings layout
//  in a memory block
//
//  layout:
//
//  long setver   - settings version
//  long size     - total size of the block
//  long fourCC   - selected video codec
//  long HADID    - selected audio codec
//  long wfxsize  - size of following waveformatex struc
//  [wfxsize bytes] wfx - wfx struct
//
//  ------------------ video codec settings section
//  long vidcodnum  - number of video codec settings
//  ..iteration of:
//  long fourCC
//  long settingssize
//  [settingssize bytes] settings
//  [settingssize bytes] settings_firstpass
//  [settingssize bytes] settings_secondpass

bool CSettingsManager::CreateBlock( PBYTE &pBlock, long &nBlockSize, 
                                    DWORD fourcc, DWORD hadid, CWaveFormatEx &wfx, 
                                    CArray< TVideoCodecInfo, TVideoCodecInfo & > &vidarray )
{

  pBlock = NULL;
  nBlockSize = 0;

  if( m_pBlock )
    delete []m_pBlock;

  // long size
  long ls = sizeof (long);

  // Calculate size first
  // fixed elements
  m_nBlockSize = 5 * ls;
  // wfx
  m_nBlockSize += wfx.GetSize();
  // video codec section
  m_nBlockSize += ls;

  for( int i=0; i<vidarray.GetSize(); i++ )
  {
    m_nBlockSize += 2*ls;
    m_nBlockSize += 3*vidarray[i].m_nSettingsSize;
  }

  // Allocate block
  m_pBlock = new BYTE[m_nBlockSize];

  // fill in
  PBYTE b = m_pBlock;

  *(long *)b = SETTINGS_VERSION;
  b+=ls;

  *(long *)b = m_nBlockSize;
  b+=ls;

  *(long *)b = fourcc;
  b+=ls;

  *(long *)b = hadid;
  b+=ls;

  *(long *)b = wfx.GetSize();
  b+=ls;

  memcpy( b, wfx.GetData(), wfx.GetSize() );
  b+=wfx.GetSize();

  *(long *)b = vidarray.GetSize();
  b+=ls;

  for( i=0; i<vidarray.GetSize(); i++ )
  {
    *(long *)b = vidarray[i].fccHandler;
    b+=ls;

    *(long *)b = vidarray[i].GetSettingsSize();
    b+=ls;

    memcpy( b, vidarray[i].GetSettings(), vidarray[i].GetSettingsSize() );
    b+=vidarray[i].GetSettingsSize();

    memcpy( b, vidarray[i].GetSettings1st(), vidarray[i].GetSettingsSize() );
    b+=vidarray[i].GetSettingsSize();

    memcpy( b, vidarray[i].GetSettings2nd(), vidarray[i].GetSettingsSize() );
    b+=vidarray[i].GetSettingsSize();
  }

  pBlock = m_pBlock;
  nBlockSize = m_nBlockSize;

  return true;
}

//////////////////////////////
// This class manages our settings layout
//  in a memory block
//
//  layout:
//
//  long setver   - settings version
//  long size     - total size of the block
//  long fourCC   - selected video codec
//  long HADID    - selected audio codec
//  long wfxsize  - size of following waveformatex struc
//  [wfxsize bytes] wfx - wfx struct
//
//  ------------------ video codec settings section
//  long vidcodnum  - number of video codec settings
//  ..iteration of:
//  long fourCC
//  long settingssize
//  [settingssize bytes] settings
//  [settingssize bytes] settings_secondpass
bool CSettingsManager::CreateFromBlock(  PBYTE pBlock, long nBlockSize, 
                       DWORD &fourcc, DWORD &hadid, CWaveFormatEx &wfx, 
                       CArray< TVideoCodecInfo, TVideoCodecInfo & > &vidarray )
{
  if( !pBlock || !nBlockSize )
    return false;
  
  // long size
  long ls = sizeof (long);

  // We don't really need to store the configuration block
  // We are interested in the information on it
  PBYTE b = pBlock;

  if( *(long *)b != SETTINGS_VERSION )
    return false;

  b += ls;
  
  // check size
  if( *(long *)b != nBlockSize )
    return false;
  b += ls;

  // video codec
  fourcc = *(long *)b;
  b += ls;

  // audio codec
  hadid = *(long *)b;
  b += ls;

  // wfx
  long wfxsize = *(long *)b;
  b += ls;

  wfx.SetSize( wfxsize );
  memcpy( wfx.GetData(), b, wfxsize );
  b+= wfxsize;


// video codec section
//  ------------------ video codec settings section
//  long vidcodnum  - number of video codec settings
//  ..iteration of:
//  long fourCC
//  long settingssize
//  [settingssize bytes] settings
//  [settingssize bytes] settings_secondpass
    // audio codec
  bool bHandlerFound = false;
  long fccHandler, settingssize;
  long vidcodsize = *(long *)b;
  b += ls;
  for( int i=0; i<vidcodsize; i++ )
  {
    fccHandler = *(long *)b;
    b += ls;

    settingssize = *(long *)b;
    b += ls;

    // look for a installed codec with this handler
    bool bHandlerFound = false;
    for( int j=0; j<vidarray.GetSize(); j++ )
    {
      if( vidarray[j].fccHandler == (DWORD)fccHandler ) 
      {
        if( ICGetStateSize(vidarray[j].hic) != (DWORD)settingssize )
          break;

        vidarray[j].SetSettings( b, settingssize );
        b+= settingssize;

        vidarray[j].SetSettings1st( b, settingssize );
        b+= settingssize;

        vidarray[j].SetSettings2nd( b, settingssize );
        b+= settingssize;

        bHandlerFound = true;
      }
    }

    if( !bHandlerFound )
      b += 3*settingssize;
  }

  return true;

}