/* 
 *  OptionsDlg.h
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#if !defined(AFX_OPTIONSDLG_H__867B0568_3F92_4025_8C22_EF483DF3C168__INCLUDED_)
#define AFX_OPTIONSDLG_H__867B0568_3F92_4025_8C22_EF483DF3C168__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// OptionsDlg.h : header file
//
#include <afxtempl.h>
#include <vfw.h>
#include <Msacm.h>
#include "VideoSequenceCompressor.h"
#include "AudioCompressor.h"

/////////////////////////////////////////////////////////////////////////////
// COptionsDlg dialog

#define AUDIO_UNCOMPRESSED 0x01
#define VIDEO_UNCOMPRESSED 0x02
#define AUDIO_UNKNOWN      0x04

class COptionsDlg : public CDialog
{
  // Construction
public:
  struct TSelectedResult
  {
    CStateManager *pStateManager;
    int           videoSelected;
    int           audioDriverSelected;
    int           audioFormatSelected;
    DWORD         status;           // Status flag for result
  };
  


  // Select default, return results
  TSelectedResult m_sResult;

	COptionsDlg(CWnd* pParent = NULL);   // standard constructor

  CArray< TVideoCodecInfo, 
          TVideoCodecInfo & > m_vVideoCodecList;
  CArray< CAudioCodecInfo, 
          CAudioCodecInfo & > m_vAudioCodecList;

// Dialog Data
	//{{AFX_DATA(COptionsDlg)
	enum { IDD = IDD_OPTIONS };
	CButton	m_SecondPassButton;
	CButton	m_FirstPassButton;
	CListBox	m_lAudioFormatListBox;
	CListBox	m_lAudioListBox;
	CListBox	m_lVideoList;
	CString	m_csVideoFourCC;
	CString	m_csVideoDriverName;
	CString	m_csConfAval;
	CString	m_csFormatsSupported;
	//}}AFX_DATA
  

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(COptionsDlg)
	public:
	virtual int DoModal();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(COptionsDlg)
	afx_msg void OnSelchangeVideolist();
	virtual BOOL OnInitDialog();
	afx_msg void OnDblclkVideolist();
	virtual void OnOK();
	afx_msg void OnSelchangeAudiolist();
	afx_msg void OnSelchangeAudioformatlist();
	afx_msg void OnSecondpass();
	afx_msg void OnConfigure();
	afx_msg void OnFirstpass();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_OPTIONSDLG_H__867B0568_3F92_4025_8C22_EF483DF3C168__INCLUDED_)
