/* 
 *  OptionsDlg.cpp
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */



#include "stdafx.h"
#include "OpenDMLAVIOutput.h"
#include "OptionsDlg.h"
#include "vfw.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptionsDlg dialog


COptionsDlg::COptionsDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COptionsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptionsDlg)
	m_csVideoFourCC = _T("");
	m_csVideoDriverName = _T("");
	m_csConfAval = _T("");
	m_csFormatsSupported = _T("");
	//}}AFX_DATA_INIT


}


void COptionsDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptionsDlg)
	DDX_Control(pDX, IDC_SECONDPASS, m_SecondPassButton);
	DDX_Control(pDX, IDC_FIRSTPASS, m_FirstPassButton);
	DDX_Control(pDX, IDC_AUDIOFORMATLIST, m_lAudioFormatListBox);
	DDX_Control(pDX, IDC_AUDIOLIST, m_lAudioListBox);
	DDX_Control(pDX, IDC_VIDEOLIST, m_lVideoList);
	DDX_Text(pDX, IDC_VIDEO_FOURCC, m_csVideoFourCC);
	DDX_Text(pDX, IDC_VIDEODRIVERNAME, m_csVideoDriverName);
	DDX_Text(pDX, IDC_CONFAVAL, m_csConfAval);
	DDX_Text(pDX, IDC_FORMSUPPORTED, m_csFormatsSupported);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptionsDlg, CDialog)
	//{{AFX_MSG_MAP(COptionsDlg)
	ON_LBN_SELCHANGE(IDC_VIDEOLIST, OnSelchangeVideolist)
	ON_LBN_DBLCLK(IDC_VIDEOLIST, OnDblclkVideolist)
	ON_LBN_SELCHANGE(IDC_AUDIOLIST, OnSelchangeAudiolist)
	ON_LBN_SELCHANGE(IDC_AUDIOFORMATLIST, OnSelchangeAudioformatlist)
	ON_BN_CLICKED(IDC_SECONDPASS, OnSecondpass)
	ON_BN_CLICKED(IDC_CONFIGURE, OnConfigure)
	ON_BN_CLICKED(IDC_FIRSTPASS, OnFirstpass)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptionsDlg message handlers

void COptionsDlg::OnSelchangeVideolist() 
{
  // TODO: Add your control notification handler code here
  int idx          = m_lVideoList.GetCurSel();

  // If we have compressed video
  if( idx < m_vVideoCodecList.GetSize() )
  { 
    DWORD fccHandler = m_vVideoCodecList[idx].fccHandler;
    m_csVideoFourCC.Format( "%c%c%c%c", fccHandler&0xFF, 
                            (fccHandler>>8)&0xFF,
                            (fccHandler>>16)&0xFF,
                            (fccHandler>>24)&0xFF );
    
    m_csVideoDriverName = CString( m_vVideoCodecList[idx].szDriver );
    // Guess if there is configuration available
    HIC hic;
    if( hic = m_vVideoCodecList[idx].hic )
      m_csConfAval = ICQueryConfigure( hic )!=ICERR_OK ? "Yes" : "No";

    // Supported input formats
    DWORD dwFormats = m_vVideoCodecList[idx].dwSupportedFormats;

    m_csFormatsSupported = dwFormats&FLO_VIDEO_RGB32 ? "RGB " : "";
    m_csFormatsSupported += dwFormats&FLO_VIDEO_YUY2 ? "YUY2 " : "";
    m_csFormatsSupported += dwFormats&FLO_VIDEO_YV12 ? "YV12 " : "";

  }
  else
  {
    m_csVideoFourCC = CString("");
    m_csVideoDriverName = CString("");
    m_csConfAval = "No";
    m_csFormatsSupported = "";
  }
  UpdateData( FALSE );
}

int COptionsDlg::DoModal() 
{
	// TODO: Add your specialized code here and/or call the base class

	return CDialog::DoModal();
}

BOOL COptionsDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
  m_SecondPassButton.EnableWindow(FALSE);
  // Populate list

  // Video Codecs
  for( int i=0; i<m_vVideoCodecList.GetSize(); i++ )
    m_lVideoList.AddString( CString(m_vVideoCodecList[i].szDescription) );	
  // Add the uncompressed option
  m_lVideoList.AddString( CString("<< Uncompressed Video >>") );

  // Audio Codecs
  // Codecs
  for( i=0; i<m_vAudioCodecList.GetSize(); i++ )
    m_lAudioListBox.AddString( CString(m_vAudioCodecList[i].szDriverName) );	
  // Add the uncompressed audio option
  m_lAudioListBox.AddString( CString("<< Uncompressed PCM Audio >>") );


  //
  if( m_sResult.status & VIDEO_UNCOMPRESSED )
    m_lVideoList.SetCurSel(m_vVideoCodecList.GetSize());
  else
    m_lVideoList.SetCurSel(m_sResult.videoSelected);

  if( m_sResult.status & AUDIO_UNCOMPRESSED )
    m_lAudioListBox.SetCurSel(m_vAudioCodecList.GetSize());
  else
  {
    m_lAudioListBox.SetCurSel(m_sResult.audioDriverSelected);
    m_lAudioFormatListBox.SetCurSel(m_sResult.audioFormatSelected);
  }

  // Update info
  OnSelchangeVideolist();
  OnSelchangeAudiolist();
  OnSelchangeAudioformatlist();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void COptionsDlg::OnFirstpass() 
{
  HIC hic;
	// Show configuration dialog if any.
  int idx          = m_lVideoList.GetCurSel();
  if( idx < m_vVideoCodecList.GetSize() )
  {
    // Try to get a specific state for this driver
    DWORD fccHandler = m_vVideoCodecList[idx].fccHandler;

    // First open the codec
    if(hic = m_vVideoCodecList[idx].hic )
    {
      ICSetState( hic, m_vVideoCodecList[idx].GetSettings1st(),  
                       m_vVideoCodecList[idx].GetSettingsSize() );

      if( ICConfigure( hic, m_hWnd ) != ICERR_OK )
        OutputDebugString("COptionsDlg::OnDblclkVideolist()  - Codec has no configuration \n");

      DWORD size;
      size = ICGetStateSize(hic);
      if( size )
      {
        PBYTE pv = new BYTE[size];
        ICGetState( hic, pv, size );
        m_vVideoCodecList[idx].SetSettings1st( pv, size );
        delete []pv;
      }
    }
  }	
  m_FirstPassButton.EnableWindow(FALSE);
  m_SecondPassButton.EnableWindow();
}

void COptionsDlg::OnSecondpass() 
{
  HIC hic;
	// Show configuration dialog if any.
  int idx          = m_lVideoList.GetCurSel();
  if( idx < m_vVideoCodecList.GetSize() )
  {
    // Try to get a specific state for this driver
    DWORD fccHandler = m_vVideoCodecList[idx].fccHandler;

    // First open the codec
    if(hic = m_vVideoCodecList[idx].hic )
    {
      ICSetState( hic, m_vVideoCodecList[idx].GetSettings1st(),  
                       m_vVideoCodecList[idx].GetSettingsSize() );

      if( ICConfigure( hic, m_hWnd ) != ICERR_OK )
        OutputDebugString("COptionsDlg::OnDblclkVideolist()  - Codec has no configuration \n");

      DWORD size;
      size = ICGetStateSize(hic);
      if( size )
      {
        PBYTE pv = new BYTE[size];
        ICGetState( hic, pv, size );
        m_vVideoCodecList[idx].SetSettings2nd( pv, size );
        delete []pv;
      }
    }
  }	
  m_SecondPassButton.EnableWindow(FALSE);
  m_FirstPassButton.EnableWindow();
}

void COptionsDlg::OnDblclkVideolist() 
{
  //static BYTE stateBlock[1000];
  //static int stateSize = 120;
  HIC hic;
	// Show configuration dialog if any.
  int idx          = m_lVideoList.GetCurSel();
  if( idx < m_vVideoCodecList.GetSize() )
  {
    // Try to get a specific state for this driver
    DWORD fccHandler = m_vVideoCodecList[idx].fccHandler;

    // First open the codec
    if(hic = m_vVideoCodecList[idx].hic )
    {
      ICSetState( hic, m_vVideoCodecList[idx].GetSettings(),  
                       m_vVideoCodecList[idx].GetSettingsSize() );

      if( ICConfigure( hic, m_hWnd ) != ICERR_OK )
        OutputDebugString("COptionsDlg::OnDblclkVideolist()  - Codec has no configuration \n");

      DWORD size;
      size = ICGetStateSize(hic);
      if( size )
      {
        PBYTE pv = new BYTE[size];
        ICGetState( hic, pv, size );
        m_vVideoCodecList[idx].SetSettings( pv, size );
        delete []pv;
      }
    }
  }
	return;
}

void COptionsDlg::OnOK() 
{
  // TODO: Add extra validation here
  int idx          = m_lVideoList.GetCurSel();
  
  m_sResult.status = 0;
  
  if( idx < m_vVideoCodecList.GetSize() )
    m_sResult.videoSelected = idx;
  else
    m_sResult.status |= VIDEO_UNCOMPRESSED;
  
  // Get audio tag selected. Left pane.
  idx = m_lAudioListBox.GetCurSel();
  // If its not PCM get the whole format structure.
  //  If idx is >= means that PCM is selected.
  if( idx < m_vAudioCodecList.GetSize() )
  { 
    
    // Get the driver ID for that tag
    m_sResult.audioDriverSelected = idx;
	  m_sResult.audioFormatSelected = m_lAudioFormatListBox.GetCurSel();
  }
  else
    m_sResult.status |= AUDIO_UNCOMPRESSED;

	CDialog::OnOK();
}


void COptionsDlg::OnSelchangeAudiolist() 
{
	// Populate format list
  int idx = m_lAudioListBox.GetCurSel();
  
  m_lAudioFormatListBox.ResetContent();
  // If PCM format was selected
  if(idx >= m_vAudioCodecList.GetSize() ) return;

  int formatSize = m_vAudioCodecList[idx].m_vFormatDetailsList.GetSize();


  for( int i=0; i<formatSize; i++ )
  {
    CString sPres = m_vAudioCodecList[idx].m_vFormatTagStrings[i] + CString(" - ") +
                    m_vAudioCodecList[idx].m_vFormatDetailsList[i].szFormat;

    m_lAudioFormatListBox.AddString( sPres );
  }
  // Select the first one
  if( m_lAudioFormatListBox.SetCurSel( m_sResult.audioFormatSelected )== LB_ERR  )
    m_lAudioFormatListBox.SetCurSel( 0 );

  UpdateData( FALSE );
}

void COptionsDlg::OnSelchangeAudioformatlist() 
{
	// TODO: Add your control notification handler code here
  m_sResult.audioFormatSelected = m_lAudioFormatListBox.GetCurSel();
}



void COptionsDlg::OnConfigure() 
{
  OnDblclkVideolist();	
}

