/* 
 *  OpenDMLAVIOutput.cpp
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#if !defined(AFX_OPENDMLAVIOUTPUT_H__02F95787_DF6E_4FDD_81EB_BA7558CEDFDD__INCLUDED_)
#define AFX_OPENDMLAVIOUTPUT_H__02F95787_DF6E_4FDD_81EB_BA7558CEDFDD__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"		// main symbols
// Premiere includes
#include <mmsystem.h>
#include <vfw.h>
#include <mmreg.h>
#include <Msacm.h>
#include "AVIoutput.h"
#include "VideoSequenceCompressor.h"
#include "AudioCompressor.h"
#include "settingsmanager.h"
#include "stateManager.h"
#include "..\include\floutapi.h"

// Definitions
#define ODMLtype	'DML2'		// 'ODML' type

/////////////////////////////////////////////////////////////////////////////
// COpenDMLAVIOutputApp
// See OpenDMLAVIOutput.cpp for the implementation of this class
//

class COpenDMLAVIOutputApp : public CWinApp
{
public:
/*

  // When starting the compile this function makes sure that a video codec is installed.
	bool CompileConfigurePreferences( compStdParms *stdParms, compDoCompileInfo *compileInfo, int idx );
  bool InitCompileFormats(compStdParms *stdParms, compDoCompileInfo *compileInfo, int idx, DWORD dwInFccCode,    int  nInBitsPerPel  );
  bool DeInitCompileFormats();
	int QueryOutputFormat( compOutputRec *outputRec );
	int GetAudioIndFormat( compStdParms *stdParms, compAudioInfoRec *audioInfoRec, int idx );
	int GetIndFormat( compFileInfoRec *fileInfoRec, int idx );
  int GetFilePrefs( compStdParms *stdParms, compGetFilePrefsRec *fileInfoRec, int idx );
  int DoCompile( compStdParms *stdParms, compDoCompileInfo *compileInfo, int idx );
  int QueryFormatOutputInfo( compStdParms *stdParms, compQueryOutputFormatInfoRec *outputFormatInfoRec, int idx);
*/
	flreturn_t startup( startup_s *st );
  flreturn_t shutdown();
  flreturn_t configure();
  flreturn_t compile(compile_s *cs);
  flreturn_t getinfo(ui32 par1, ui32 par2);
  flreturn_t setinfo(ui32 par1, ui32 par2);

	bool ShowOptionsDlg();
  bool UpdateCodecNames();
  bool ConfigureCodecs(videodef_s *vd, audiodef_s *ad);
  bool InitCompileFormats( videodef_s *vd, audiodef_s *ad, DWORD dwInFccCode, int  nInBitsPerPel);
  bool DeInitCompileFormats();
  flreturn_t DoCompile( compile_s *cs, videodef_s *vd, audiodef_s *ad);
  flreturn_t DoFirstPass( compile_s *cs, videodef_s *vd, DWORD dwInFcccode, long nBitsPerPixel );
  int  DoCompileInitAVIStreams(videodef_s *vd, audiodef_s *ad );
  void From32to24( PBYTE inImage, PBYTE outImage, long inSize );
	COpenDMLAVIOutputApp();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(COpenDMLAVIOutputApp)
	//}}AFX_VIRTUAL

	//{{AFX_MSG(COpenDMLAVIOutputApp)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:


/*  int DoCompileInitAVIStreams(compStdParms *stdParms, compOutputRec *compOutputRec );
  int GetInputSettings(compStdParms *stdParms, int setting);
  void From32to24( PBYTE in, PBYTE out, long inSize);
*/
  AVIOutputFile          *m_pAVIFile;

  VideoSequenceCompressor m_oVidComp;
  CAudioCompressor        m_oAudComp;

  CStateManager           m_oStateManager;

  LPBITMAPINFOHEADER      m_pBitmapInfoHdr;
  long                    m_nBitmapInfoHdrSize;

  LPWAVEFORMATEX          m_pWaveFormatEx;
  long                    m_nWaveFormatExSize;

  PBYTE                   m_pUncompFrame;

  char                    m_vVideoFormatName[256];
  char                    m_vAudioFormatName[256];

  CSettingsManager sm;
};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_OPENDMLAVIOUTPUT_H__02F95787_DF6E_4FDD_81EB_BA7558CEDFDD__INCLUDED_)
