/* 
 *  AudioCompressor.cpp
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#if !defined(AFX_AUDIOCOMPRESSOR_H__10D13B53_9E4C_4EEC_8FDB_75E18F87AB0B__INCLUDED_)
#define AFX_AUDIOCOMPRESSOR_H__10D13B53_9E4C_4EEC_8FDB_75E18F87AB0B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define AUDIO_BUFFER_SIZE 0x7FFFF
#define MIN_AUDIO_BUFFER  0x7FFF


class CWaveFormatEx : public CByteArray
{
public:
  CWaveFormatEx& operator=( const CWaveFormatEx &src )
  {
    Copy( src );
    return *this;
  };
  WAVEFORMATEX *Get(){ return (WAVEFORMATEX *)GetData(); };
};

class CAudioCodecInfo
{
public:
  // MFC doesnt define the assigment operator for CArray class.
  CAudioCodecInfo& operator =( const CAudioCodecInfo& src )
  {
    strcpy( szDriverName, src.szDriverName );
    hadid     = src.hadid;
    m_vFormatDetailsList.Copy( src.m_vFormatDetailsList );
    m_vWaveFormatExList.Copy( src.m_vWaveFormatExList );
    m_vFormatTagStrings.Copy( src.m_vFormatTagStrings );
    return *this;
  };
  
  char szDriverName[ACMDRIVERDETAILS_LONGNAME_CHARS];
  HACMDRIVERID hadid;
  CArray< ACMFORMATDETAILS, ACMFORMATDETAILS & > m_vFormatDetailsList;
  CArray< CWaveFormatEx, CWaveFormatEx &>  m_vWaveFormatExList;
  CStringArray m_vFormatTagStrings;
  
};
  

class CAudioCompressor  
{
public:

  CArray< CAudioCodecInfo, CAudioCodecInfo & > m_vAudioCodecList;
  
  HACMDRIVER m_hHad; // Handle to opened driver
  HACMDRIVERID m_hHadId; // Handlde to the opened driver id

  char szDriverName[ACMDRIVERDETAILS_LONGNAME_CHARS];

  
  bool InitAudioCompressor(HACMDRIVERID hadid, int sampleFreq, int channels, int bitsPerSample, WAVEFORMATEX *wfxOut);  
  bool DeInitAudioCompressor();
  bool Compress(PBYTE inAudio, long inSize, PBYTE &outAudio, unsigned long &outSize);
  bool EnumerateAudioCodecs( int sampleFreq, int channels, int bitsPerSample, bool bDeleteOld = true );
  bool FormatIsInstalled(  HACMDRIVERID hadid, WAVEFORMATEX *wfx, int cbSize, int *dwFormatTagIdx, int *FormatIdx );  
  
  CAudioCompressor();
  virtual ~CAudioCompressor(); 
  
  int m_nSampleFreq;
  int m_nChannels;
  int m_nBitsPerSample;
  private:
    PBYTE pInAudio, pOutAudio;
    ACMSTREAMHEADER m_sStreamHdr;
    HACMSTREAM m_hHas; //Handle to opened stream conversion 
    long m_nBufferPtr;
};

#endif // !defined(AFX_AUDIOCOMPRESSOR_H__10D13B53_9E4C_4EEC_8FDB_75E18F87AB0B__INCLUDED_)
