//==========================================================================;
//
//  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
//  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
//  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
//  PURPOSE.
//
//  Copyright 1992 - 1998 Microsoft Corporation.  All Rights Reserved.
//
//--------------------------------------------------------------------------;
//
//  debug.c
//
//  Description:
//      This file contains code yanked from several places to provide debug
//      support that works in win 16 and win 32.
//
//
//==========================================================================;

#ifdef _DEBUG
#include <windows.h> 
#include <windowsx.h>
#include <mmsystem.h>
#include <stdarg.h>
#include "windebug.h"

BOOL    __gfDbgEnabled          = TRUE;         // master enable
UINT    __guDbgLevel            = 0;            // current debug level


//--------------------------------------------------------------------------;
//
//  void DbgVPrintF
//
//  Description:
//
//
//  Arguments:
//      LPSTR szFormat:
//
//      va_list va:
//
//  Return (void):
//      No value is returned.
//
//--------------------------------------------------------------------------;

#define DEBUG_MAX_LINE_LEN 2048

void FAR CDECL DbgVPrintF
(
    LPSTR                   szFormat,
    va_list                 va
)
{
    char                ach[DEBUG_MAX_LINE_LEN];
    BOOL                fDebugBreak = FALSE;
    BOOL                fPrefix     = TRUE;
    BOOL                fCRLF       = TRUE;

    ach[0] = '\0';

    for (;;)
    {
        switch (*szFormat)
        {
            case '!':
                fDebugBreak = TRUE;
                szFormat++;
                continue;

            case '`':
                fPrefix = FALSE;
                szFormat++;
                continue;

            case '~':
                fCRLF = FALSE;
                szFormat++;
                continue;
        }

        break;
    }

    if (fDebugBreak)
    {
        ach[0] = '\007';
        ach[1] = '\0';
    }
    wvsprintfA(ach + lstrlenA(ach), szFormat, va);

    if (fCRLF)
    {
        lstrcatA(ach, "\r\n");
    }

    OutputDebugStringA(ach);

    if (fDebugBreak)
    {
        DebugBreak();
    }
} // DbgVPrintF()


//--------------------------------------------------------------------------;
//
//  void dprintf
//
//  Description:
//      dprintf() is called by the DPF() macro if DEBUG is defined at compile
//      time. It is recommended that you only use the DPF() macro to call
//      this function--so you don't have to put #ifdef DEBUG around all
//      of your code.
//
//  Arguments:
//      UINT uDbgLevel:
//
//      LPSTR szFormat:
//
//  Return (void):
//      No value is returned.
//
//--------------------------------------------------------------------------;

void FAR CDECL dprintf
(
//    UINT                    uDbgLevel,
    LPSTR                   szFormat,
    ...
)
{
    va_list va;

 //   if (!__gfDbgEnabled || (__guDbgLevel < uDbgLevel))
  //      return;

    va_start(va, szFormat);
    //DbgVPrintF(szFormat, va);
    va_end(va);
} // dprintf()



#endif // #ifdef DEBUG



