/* 
 *  registry.cpp - Windows registry stuff
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
 
#include "flaskmpeg.h"

HKEY MyKey;
void SaveRegistryConfig( TConfig *Config )
{
	RegSetValueEx( MyKey , "Config" , NULL , REG_BINARY , (CONST BYTE *)  Config , sizeof(TConfig));
	RegCloseKey(MyKey);
	return;
}



int LoadRegistryConfig( TConfig *Config )
{
	int error;
	DWORD Disposition;
	CHAR Class[MAX_PATH];
	error=RegCreateKeyEx( HKEY_CURRENT_USER,
			   "Software\\FlasK Development\\FlasK MPEG",
			   NULL,
			   Class,
			   REG_OPTION_NON_VOLATILE,
			   KEY_ALL_ACCESS,
			   NULL,
			   &MyKey,
			   &Disposition);

	if(Disposition==REG_CREATED_NEW_KEY)
	{
	//The key didn't exist, so this is the first time Flaskmpeg
	//is running. Leave defaults

	return 0;
	}

	if(Disposition==REG_OPENED_EXISTING_KEY)
	{
	//The key existed, so load configuration in Config
	unsigned long size_temp=sizeof(TConfig);
	RegQueryValueEx( MyKey,"Config",NULL, NULL, (LPBYTE) Config , &size_temp);
	return 1;
	}



return 0;
}
