// VideoSource.h: interface for the CVideoSource class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VIDEOSOURCE_H__31E17FD4_34FF_427F_B557_097F07BDAC72__INCLUDED_)
#define AFX_VIDEOSOURCE_H__31E17FD4_34FF_427F_B557_097F07BDAC72__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "thread.h"
#include "flasktypes.h"
#include "framesource.h"
#include "framebuffer.h"
#include <list>


using namespace std;




// Return values
#define FRAME_OK         0x01
#define FRAME_NOTPRESENT 0x10

class CVideoSource: public CFlThread
{
public:
  CVideoSource(CFrameSource *pSource, int nWidth, int nHeigth, 
               int nProcessedWidth, int nProcessedHeight)
  {
    m_pFrameSource = pSource;
    m_pTempFrame = NULL;
    m_pProcessedQueue = new CListFrameBuffer( nWidth, nHeigth, FRAME_RGB, 32, 10);
    // FIXME :  the buffer size of post processed frames has to be larger than the final size
    m_pProcessedQueue->AdjustSize(nProcessedWidth, nProcessedHeight);

    m_pOutputQueue    = new CQueueFrameBuffer();
    m_nCommand = noCommand;
    Create();
  }
  virtual ~CVideoSource()
  { 
    // Terminate the thread
    m_evFinish.Reset();
    {
      CFlAutoLock lockObject(&m_csObject);
      m_nCommand = exit;
      m_evCommandTrigger.Set();
    }
    m_evFinish.Wait();

    // Close the thread
    Close();

    if( m_pProcessedQueue )
      delete m_pProcessedQueue;

    if( m_pOutputQueue )
      delete m_pOutputQueue;

    if(m_pTempFrame) 
      delete m_pTempFrame;

  }

  ui32 GetFrame(CFrame **ppFrame);


private:

  enum Commands
  {
      getFrame=THREAD_COMMAND_COUNT
  };
  enum States 
  {
      stStopped=0, stGetFrame
  };
  // Actual running thread
  DWORD ThreadProc();

  CListFrameBuffer   *m_pProcessedQueue;
  CQueueFrameBuffer  *m_pOutputQueue;

  States           m_nState;
  CFlEvent         m_evProcessedQueueSignal;
  CFlEvent         m_evCommandTrigger;
  CFlEvent         m_evFinish;
  ui64           m_nParam;
  ui64           m_nCommandResult;
  
  CFrameSource *m_pFrameSource;

  CFrame     *m_pTempFrame;
  CFlCritSec m_csCommand;
  CFlCritSec m_csObject;

};


#endif // !defined(AFX_VIDEOSOURCE_H__31E17FD4_34FF_427F_B557_097F07BDAC72__INCLUDED_)
