// VideoSource.cpp: implementation of the CVideoSource class.
//
//////////////////////////////////////////////////////////////////////

#include "VideoSource.h"
#include "postprocessing.h"
#include "runstate.h"
#include "windebug.h"

extern TRunState rs;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
 
//  
// Actual running thread

ui32 CVideoSource::GetFrame(CFrame **ppFrame)
{
  // If there are more than 8 frames to be
  // processed in the queue
  // awake the decoder to start working
  if(m_pProcessedQueue->GetSize()>=8)
  {
    CFlAutoLock lockObject(&m_csObject);
    m_nCommand = getFrame;
    m_evCommandTrigger.Set();
  }
  DBG_STR((str, "%d ", m_pProcessedQueue->GetSize() ));

  if(!(*ppFrame = m_pOutputQueue->RemoveFrame()))
    return FRAME_NOTPRESENT;
  if((*ppFrame)->IsLastFrame())
    return FRAME_NOTPRESENT;

  return FRAME_OK;
}

DWORD CVideoSource::ThreadProc()
{
  m_nState = stStopped;

  CFrame *pOutputFrame;
  CFrame *pDecodedFrame;

  while(1)
  {
    // open scope to lock command
    {
      CFlAutoLock commandLock(&m_csCommand);
      switch( m_nCommand )
      {
      case noCommand:
        break;
      case getFrame:
        m_nState = stGetFrame;
        break;
      case exit:
        // Signal exit event
        m_evFinish.Set();
        // Exit
        return 0;
        break;
      }
    }
    switch( m_nState )
    {
    case stGetFrame:
      
      // If the queue is almost empty means that you've processed
      // all those.
      // stop
      if(m_pProcessedQueue->GetSize()<=2)
      {
        m_nState = stStopped;
        break;
      }   

      // Get a free frame from the processed buffer
      if(!(pOutputFrame = m_pProcessedQueue->GetFreeFrame() ))
      {
        m_nState = stStopped;
        break;
      }

      // Get a new frame
      if(m_pFrameSource->GetFrame(&pDecodedFrame))
      {
        PostProcess(pDecodedFrame, pOutputFrame, &rs.pp);
        // Add time info
        pOutputFrame->SetPresTime( pDecodedFrame->GetPresTime() );
        // Add processed frame to the output queue
        m_pOutputQueue->AddFrame( pOutputFrame );
        // Release decoded
        pDecodedFrame->Release();
      }
      else
      {
        // Likely the last frame in the stream
        pOutputFrame->Erase();
        pOutputFrame->SetLastFrame();

        m_pOutputQueue->AddFrame( pOutputFrame );

      }
      break;
      
    }
    // If we are stopped, wait for a command
    if( m_nState == stStopped )
      m_evCommandTrigger.Wait();
  }
}