/* 
 *  VideoRenderer.h 
 *
 *	Copyright (C) Alberto Vigata - July 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#if !defined(AFX_VIDEORENDERER_H__76B3ADF0_38CE_4243_890F_89B05B944B77__INCLUDED_)
#define AFX_VIDEORENDERER_H__76B3ADF0_38CE_4243_890F_89B05B944B77__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <windows.h>
#include "thread.h"
#include "framesource.h"


#include "ddraw.h"

#define SafeRelease(x) { (x)->Release(); (x)=NULL; }

class CVideoRenderer  
{
public:
  CVideoRenderer(HWND hRenderWnd);
  virtual ~CVideoRenderer();
  void Draw(CFrame *pFrame);
  void Update();
  void SetBackground(CFrame *pFrame);
  void StartPlaying(){ m_nState = Playing; }
  void Pause(CFrame *pPausedFrame){ m_oPausedFrame = *pPausedFrame; m_nState=Paused;}
  void StopPlaying(){ m_nState = Stopped; }
  void StepBackground();
  enum OverlayMode { YuvMode=0, RgbMode };
  enum RendererState { Stopped=0, Paused, Playing };
private:
  // DirectDraw support
  // Try to open direct draw driver
  bool OpenDirectDraw();
  void CloseDirectDraw();
  bool IsRGBOverlayAvailable();
  bool IsYUVOverlayAvailable();
  bool OpenOverlay(OverlayMode);
  void CloseOverlay();
  // 
  bool m_bDDrawPresent;
  bool m_bDDCanUseYuvOverlay;
  bool m_bDDCanUseRgbOverlay;

  // DirectDraw object
  LPDIRECTDRAW  m_pDD;
  // DirectDraw interface
  IDirectDraw2 *m_pDD2;
  // Primary surface
  DDSURFACEDESC         m_sDDPrimaryDesc;
  LPDIRECTDRAWSURFACE   m_pDDPrimary;
  // Overlay surface 
  DDSURFACEDESC         m_sDDOverlayDesc;
  LPDIRECTDRAWSURFACE   m_pDDOverlay;
  // Hal caps
  DDCAPS m_sDDHalCaps;


  CFrame m_oBackground;
  CFrame m_oPausedFrame;
  HWND m_hRenderWnd;

  DWORD m_nWidth;
  DWORD m_nHeiht;
  // Background
  double fTime;
  double fPhase1, fPhase2;

  RendererState m_nState;
//  IID_IDirectDraw2 *pDD2;

};


#endif // !defined(AFX_VIDEORENDERER_H__76B3ADF0_38CE_4243_890F_89B05B944B77__INCLUDED_)
