/* store.c, picture output routines                                         */

/* Copyright (C) 1996, MPEG Software Simulation Group. All Rights Reserved. */

/*
 * Disclaimer of Warranty
 *
 * These software programs are available to the user without any license fee or
 * royalty on an "as is" basis.  The MPEG Software Simulation Group disclaims
 * any and all warranties, whether express, implied, or statuary, including any
 * implied warranties or merchantability or of fitness for a particular
 * purpose.  In no event shall the copyright-holder be liable for any
 * incidental, punitive, or consequential damages of any kind whatsoever
 * arising from the use of these programs.
 *
 * This disclaimer of warranty extends to the user of these programs and user's
 * customers, employees, agents, transferees, successors, and assigns.
 *
 * The MPEG Software Simulation Group does not represent or warrant that the
 * programs furnished hereunder are free of infringement of any third-party
 * patents.
 *
 * Commercial implementations of MPEG-1 and MPEG-2 video, including shareware,
 * are subject to royalty fees to patent holders.  Many of these patents are
 * general enough such that they are unavoidable regardless of implementation
 * design.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>

#include "config.h"

extern "C"
{
#include "global.h"
}
#include "..\Video\VideoWrapper.h"

extern VideoWrapper *myVideo;
extern void Deinitialize_Sequence _ANSI_ARGS_((void));
/* private prototypes */


static void  store_yuv _ANSI_ARGS_((unsigned char *src[],
  int offset, int incr, int height));


/*
 * store a picture as either one frame or two fields
 */
void Write_Frame(unsigned char *src[], int frame)
{
  if (progressive_sequence || progressive_frame || Frame_Store_Flag)
  {
    /* progressive */
    store_yuv(src,0,Coded_Picture_Width,vertical_size);
  }
  else
  {
    /* interlaced */
    store_yuv(src,0,Coded_Picture_Width<<1,vertical_size>>1);

    store_yuv(src,
      Coded_Picture_Width,Coded_Picture_Width<<1,vertical_size>>1);
  }
}


/* separate headerless files for y, u and v */
static void  store_yuv(
unsigned char *src[],
int offset,
int incr,
int height)
{
  int hsize;


  hsize = horizontal_size;


  myVideo->YUV.Y=		src[0];
  myVideo->YUV.Yxsize=  hsize;
  myVideo->YUV.Yysize=  height;

  if (chroma_format!=CHROMA444)
  {
    offset>>=1; incr>>=1; hsize>>=1;
  }

  if (chroma_format==CHROMA420)
  {
    height>>=1;
  }

  myVideo->YUV.U=		src[1];
  myVideo->YUV.V=		src[2];
  myVideo->YUV.Cxsize=  hsize;
  myVideo->YUV.Cysize=  height;

  return;

}

