// IEEE1180Test.h: interface for the CIEEE1180Test class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_IEEE1180TEST_H__894E2496_042A_464F_826F_5E579A46138B__INCLUDED_)
#define AFX_IEEE1180TEST_H__894E2496_042A_464F_826F_5E579A46138B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define DCTSIZE      (8)
#define DCTSIZE2     (DCTSIZE*DCTSIZE)

#define EIGHT_BIT_SAMPLES

typedef short DCTELEM;		/* must be at least 16 bits */

typedef DCTELEM DCTBLOCK[DCTSIZE2];


class CIEEE1180Test  
{
public:
	CIEEE1180Test();
	virtual ~CIEEE1180Test();
  bool IsIEEE1180( void (* TestIdct)(DCTELEM *block) );
private:
	bool Meets (double val, double limit);

	bool DoTest( long minpix, long maxpix, long sign, long niters, void (* TestIdct)(DCTELEM *block) );
	long IEEERand(long L, long H);
	void DCTInit();
	void RefInverseDCT( DCTELEM *block );
	void RefForwardDCT( DCTELEM *block );

  /* The cosine lookup table */
  /* coslu[a][b] = C(b)/2 * cos[(2a+1)b*pi/16] */
  double coslu[8][8];
  long sumerrs[DCTSIZE2];
  long sumsqerrs[DCTSIZE2];
  int maxerr[DCTSIZE2];

  // Random generator
  long randx;
  double z;
};

#endif // !defined(AFX_IEEE1180TEST_H__894E2496_042A_464F_826F_5E579A46138B__INCLUDED_)
