/* 
 *  IDCT API - provides custom iDCT libraries for FlasKMPEG MPEG decoder.
 *
 *	Copyright (C) Alberto Vigata - December 2000  ultraflask@yahoo.com
 *                 
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#define	FMPEG_IDCT_VERSION		0x00000100
#define	FMPEG_IDCT_OK		  		0x00000004
#define	FMPEG_IDCT_ERROR			0x00000005

// Flags definition
#define SUPPORTS_MMX          0x00000001  // Use this flags to indicate
#define SUPPORTS_SSE          0x00000002  // that the iDCT needs the
#define SUPPORTS_SSE2         0x00000004  // technology to work
#define SUPPORTS_3DNOW        0x00000008

#define IEEE1180_COMPLIANT    0x00000010  // iDCT passes IEEE1180 test
#define FLOATING_POINT        0x00000020  // iDCT uses floating point calculations
#define INTEGER               0x00000040  // iDCT uses integer calculations

typedef	struct {
	DWORD	dwSize;					    // Size of this structure
  DWORD dwVersion;          // Must be FMPEG_IDCT_VERSION
	char	sName[32];          // Name of the iDCT
  char  sDescription[256];  // Description of the iDCT
  void (*InitIdct)(void);    // Permorm initializations. Can be NULL.
  void (*Idct)(short *block); // Perform iDCT
  void (*DeInitIdct)(void);  // Clear up initializations. Can be NULL.
  DWORD dwFlags;            // Flags to indicate additional features of the iDCT
} FMpegIdctInfo,*LPFMpegIdctInfo;


typedef	struct {
	int    (*GetIdctCount)();   // Return number of iDCTs implemented in this module
  void   (*GetIdct)(int idx, LPFMpegIdctInfo IdctInfo); // Get iDCT with index idx
} FMpegIdct_PluginFunc,*LPFMpegIdct_PluginFunc;

// The library must export this function
// void fmGetPluginFunc( LPFMpegIdct_PluginFunc lpPluginFunc );
typedef void (*fmGetPluginFuncPtr)(LPFMpegIdct_PluginFunc lpPluginFunc);