/* 
 *  IDCT API - provides custom iDCT libraries for FlasKMPEG MPEG decoder.
 *
 *	Copyright (C) Alberto Vigata - December 2000  ultraflask@yahoo.com
 *                 
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#include "stdafx.h"
#include "../idctapi.h"

#define IDCT_COUNT 3

extern void Fast_IDCT_SSE2(short* block);

extern void Initialize_ReferenceLo_IDCT_SSE2();
extern void ReferenceLo_IDCT_SSE2(short *block);

extern void Initialize_Reference_IDCT_SSE2();
extern void Reference_IDCT_SSE2(short *block);



int    GetIdctCount()
{
  return IDCT_COUNT;
}

void   GetIdct(int idx, LPFMpegIdctInfo IdctInfo)
{
  switch( idx )
  {
  case 0:
    IdctInfo->dwFlags       = SUPPORTS_SSE2 | IEEE1180_COMPLIANT | INTEGER;
    IdctInfo->dwSize        = sizeof( FMpegIdctInfo );
    IdctInfo->dwVersion     = FMPEG_IDCT_VERSION;
    strcpy( IdctInfo->sDescription, "Fast SSE iDCT" );
    strcpy( IdctInfo->sName       , "Fast SSE2 iDCT" );
    IdctInfo->InitIdct      = NULL;
    IdctInfo->DeInitIdct    = NULL;
    IdctInfo->Idct          = Fast_IDCT_SSE2;
    break;
  case 1:
    IdctInfo->dwFlags       = SUPPORTS_SSE2 | IEEE1180_COMPLIANT | FLOATING_POINT;
    IdctInfo->dwSize        = sizeof( FMpegIdctInfo );
    IdctInfo->dwVersion     = FMPEG_IDCT_VERSION;
    strcpy( IdctInfo->sDescription, "Reference Low iDCT SSE2" );
    strcpy( IdctInfo->sName       , "Reference Low iDCT SSE2" );
    IdctInfo->InitIdct      = Initialize_ReferenceLo_IDCT_SSE2;
    IdctInfo->DeInitIdct    = NULL;
    IdctInfo->Idct          = ReferenceLo_IDCT_SSE2;
    break;
  case 2:
    IdctInfo->dwFlags       = IEEE1180_COMPLIANT | SUPPORTS_SSE2;
    IdctInfo->dwSize        = sizeof( FMpegIdctInfo );
    IdctInfo->dwVersion     = FMPEG_IDCT_VERSION;
    strcpy( IdctInfo->sDescription, "Reference iDCT SSE2" );
    strcpy( IdctInfo->sName       , "Reference iDCT SSE2" );
    IdctInfo->InitIdct      = Initialize_Reference_IDCT_SSE2;
    IdctInfo->DeInitIdct    = NULL;
    IdctInfo->Idct          = Reference_IDCT_SSE2;
    break;
  default:
    break;
  }
}

__declspec(dllexport)  void fmGetPluginFunc(LPFMpegIdct_PluginFunc lpPluginFunc)
{
  lpPluginFunc->GetIdct      = GetIdct;
  lpPluginFunc->GetIdctCount = GetIdctCount;
}
