/* 
 *  IDCT API - provides custom iDCT libraries for FlasKMPEG MPEG decoder.
 *
 *	Copyright (C) Alberto Vigata - December 2000  ultraflask@yahoo.com
 *                 
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers

#include <windows.h>

#include "../idctapi.h"

#define IDCT_COUNT 3

// double precision (ddct) uses no extensions (?)
extern void Initialize_Reference_IDCT2(void);
extern void Reference_IDCT2( short *block);

// double precision (sdct) uses 3dnow (?)
extern void Initialize_Reference_IDCT3 (void);
extern void Reference_IDCT3 (short *block);

// 3dnow hybrid (mdct) uses 3dnow (?)
extern void Initialize_Reference_IDCT4(void);
extern void Reference_IDCT4( short *block);

int    GetIdctCount()
{
  return IDCT_COUNT;
}

void   GetIdct(int idx, LPFMpegIdctInfo IdctInfo)
{
  switch( idx )
  {
  case 0:
    IdctInfo->dwFlags       = IEEE1180_COMPLIANT | FLOATING_POINT;
    IdctInfo->dwSize        = sizeof( FMpegIdctInfo );
    IdctInfo->dwVersion     = FMPEG_IDCT_VERSION;
    strcpy( IdctInfo->sDescription, "IEEE-1180 double precision floating point iDCT optimized for AMD Athlon FPU" );
    strcpy( IdctInfo->sName       , "AMD x87 iDCT" );
    IdctInfo->InitIdct      = Initialize_Reference_IDCT2;
    IdctInfo->DeInitIdct    = NULL;
    IdctInfo->Idct          = Reference_IDCT2;
    break;
  case 1:
    IdctInfo->dwFlags       = SUPPORTS_3DNOW | IEEE1180_COMPLIANT | FLOATING_POINT;
    IdctInfo->dwSize        = sizeof( FMpegIdctInfo );
    IdctInfo->dwVersion     = FMPEG_IDCT_VERSION;
    strcpy( IdctInfo->sDescription, "IEEE-1180 double precision floating point iDCT using AMD 3dnow" );
    strcpy( IdctInfo->sName       , "AMD 3dnow iDCT" );
    IdctInfo->InitIdct      = Initialize_Reference_IDCT3;
    IdctInfo->DeInitIdct    = NULL;
    IdctInfo->Idct          = Reference_IDCT3;
    break;
  case 2:
    IdctInfo->dwFlags       = SUPPORTS_3DNOW | IEEE1180_COMPLIANT | FLOATING_POINT; // maybe we need a HYBRID define
    IdctInfo->dwSize        = sizeof( FMpegIdctInfo );
    IdctInfo->dwVersion     = FMPEG_IDCT_VERSION;
    strcpy( IdctInfo->sDescription, "IEEE-1180 Hybrid iDCT using AMD 3dnow" );
    strcpy( IdctInfo->sName       , "AMD 3dnow hybrid iDCT" );
    IdctInfo->InitIdct      = Initialize_Reference_IDCT4;
    IdctInfo->DeInitIdct    = NULL;
    IdctInfo->Idct          = Reference_IDCT4;
    break;
  default:
    break;
  }
}

__declspec(dllexport)  void fmGetPluginFunc(LPFMpegIdct_PluginFunc lpPluginFunc)
{
  lpPluginFunc->GetIdct      = GetIdct;
  lpPluginFunc->GetIdctCount = GetIdctCount;
}
