/* getbits.c, bit level routines                                            */

/*
 * All modifications (mpeg2decode -> mpeg2play) are
 * Copyright (C) 1996, Stefan Eckart. All Rights Reserved.
 */

/* Copyright (C) 1996, MPEG Software Simulation Group. All Rights Reserved. */

/*
 * Disclaimer of Warranty
 *
 * These software programs are available to the user without any license fee or
 * royalty on an "as is" basis.  The MPEG Software Simulation Group disclaims
 * any and all warranties, whether express, implied, or statuary, including any
 * implied warranties or merchantability or of fitness for a particular
 * purpose.  In no event shall the copyright-holder be liable for any
 * incidental, punitive, or consequential damages of any kind whatsoever
 * arising from the use of these programs.
 *
 * This disclaimer of warranty extends to the user of these programs and user's
 * customers, employees, agents, transferees, successors, and assigns.
 *
 * The MPEG Software Simulation Group does not represent or warrant that the
 * programs furnished hereunder are free of infringement of any third-party
 * patents.
 *
 * Commercial implementations of MPEG-1 and MPEG-2 video, including shareware,
 * are subject to royalty fees to patent holders.  Many of these patents are
 * general enough such that they are unavoidable regardless of implementation
 * design.
 *
 */

#include <stdio.h>
#include <stdlib.h>
 
#include "config.h"
extern "C"
{
#include "global.h"
}

#include "..\Video\VideoWrapper.h"

extern VideoWrapper *myVideo;

#define Get_Bits1() (Get_Bits(1))

void Fill_Buffer()
{
  bool bReadOk;

  bReadOk = myVideo->ReadVideoData( (ui8**)&ld->Rdbfr, &VIDEO_BUFFER_SIZE );

  ld->Rdmax=ld->Rdbfr + VIDEO_BUFFER_SIZE;

  ld->Rdptr = ld->Rdbfr;

  if (System_Stream_Flag)
    ld->Rdmax -= VIDEO_BUFFER_SIZE;

  myVideo->m_bReadError = false;
  /* end of the bitstream file */
  if (!bReadOk)
  {
    // Flag this to the videowrapper
    myVideo->m_bReadError = true;

    // Even when the read can fail, we can have something
    // as payload.
    // The size of the payload its at VIDEO_BUFFER_SIZE
    ui32 BufferPtr = 0;

    /* pad until the next to the next 32-bit word boundary */
    while (BufferPtr & 3)
      ld->Rdbfr[BufferPtr++] = 0;

	/* pad the buffer with sequence end codes */
    while (BufferPtr + 4 < VIDEO_BUFFER_SIZE )
    {
      ld->Rdbfr[BufferPtr++] = SEQUENCE_END_CODE>>24;
      ld->Rdbfr[BufferPtr++] = SEQUENCE_END_CODE>>16;
      ld->Rdbfr[BufferPtr++] = SEQUENCE_END_CODE>>8;
      ld->Rdbfr[BufferPtr++] = SEQUENCE_END_CODE&0xff;
    }
  }
}

/* initialize buffer, call once before first getbits or showbits */

void Initialize_Buffer()
{
  VIDEO_BUFFER_SIZE=65536; 
  ld->Incnt = 0;
  ld->Rdptr = ld->Rdbfr + VIDEO_BUFFER_SIZE;
  //ld->Rdptr = ld->Rdbfr + 2048;
  ld->Rdmax = ld->Rdptr;

#ifdef VERIFY
  /*  only the verifier uses this particular bit counter 
   *  Bitcnt keeps track of the current parser position with respect
   *  to the video elementary stream being decoded, regardless 
   *  of whether or not it is wrapped within a systems layer stream 
   */
  ld->Bitcnt = 0;
#endif

  ld->Bfr = 0;
  Flush_Buffer(0); /* fills valid data into bfr */
  //Fill_Buffer();  
}

void Reset_Bits_Buffer()
{
  ld->Incnt = 0;
  ld->Rdptr = ld->Rdmax;
}

/* return next n bits (right adjusted) without advancing */

unsigned int Show_Bits(int N)
{
  return ld->Bfr >> (32-N); 
}


/* return next bit (could be made faster than Get_Bits(1)) */
/*
unsigned int Get_Bits1()
{
  return Get_Bits(1);
}
*/

/* advance by n bits */

void Flush_Buffer(int N)
{
  int Incnt;
  	
  ld->Bfr <<= N;

  Incnt = ld->Incnt -= N;

  if (Incnt <= 24)
  {
   if (ld->Rdptr + 4 < ld->Rdbfr + VIDEO_BUFFER_SIZE )
    {
      do
      {
        ld->Bfr |= *ld->Rdptr++ << (24 - Incnt);
        Incnt += 8;
      }
      while (Incnt <= 24);
    }
    else
    {
      do
      {
        if (ld->Rdptr >= ld->Rdbfr+VIDEO_BUFFER_SIZE)
          Fill_Buffer();
        ld->Bfr |= *ld->Rdptr++ << (24 - Incnt);
        Incnt += 8;
      }
      while (Incnt <= 24);
    }
    ld->Incnt = Incnt;
  }

#ifdef VERIFY 
  ld->Bitcnt += N;
#endif 

}


/* return next n bits (right adjusted) */
/* 
unsigned int  Get_Bits(int N)
{
  unsigned int Val;

  Val = Show_Bits(N);
  Flush_Buffer(N);

  return Val;
}
*/

// This function returns the position of the 
// stream in offset bytes from the buffer
int Get_Buffer_Pos()
{
	// Work out number of bytes that were used to fill the current ld->Bfr
	int nBytesBuffer = ( ld->Incnt + 7 ) / 8;
	return ld->Rdptr - ld->Rdbfr - nBytesBuffer;
}
unsigned int Get_Buffer_Size()
{
	return VIDEO_BUFFER_SIZE;
}

// Sets the bits buffer in a known state, removing previous data.
unsigned int Set_Buffer_State( ui8 *buffer, ui32 offset, ui32 buffersize )
{
  VIDEO_BUFFER_SIZE = buffersize; 
  ld->Incnt = 0;
  ld->Rdbfr = (unsigned char *)buffer;
  ld->Rdptr = ld->Rdbfr + offset;
  ld->Rdmax = ld->Rdptr;
  ld->Bfr = 0;
  return 1;
}

unsigned int  Get_Bits(int N)
{
  unsigned int Val;
  int Incnt;
  
  Val = ld->Bfr >> (32-N);
  ld->Bfr <<= N; 
  
  Incnt = ld->Incnt -= N;

  if (Incnt <= 24)
  {
    if (ld->Rdptr < ld->Rdbfr+VIDEO_BUFFER_SIZE-4)
    {
      do
      {
        ld->Bfr |= *ld->Rdptr++ << (24 - Incnt);
        Incnt += 8;
      }
      while (Incnt <= 24);
    }
    else 
    {
      do
      {
        if (ld->Rdptr >= ld->Rdbfr+VIDEO_BUFFER_SIZE)
          Fill_Buffer();
        ld->Bfr |= *ld->Rdptr++ << (24 - Incnt);
        Incnt += 8;
      }
      while (Incnt <= 24);
    }
    ld->Incnt = Incnt;
  }

#ifdef VERIFY 
  ld->Bitcnt += N;
#endif /* VERIFY */

  return Val;
}


void Flush_Buffer32()
{
    int Incnt;
    
    ld->Bfr = 0;
    
    Incnt = ld->Incnt;
    Incnt -= 32;
    
    while (Incnt <= 24)
    {
        if (ld->Rdptr >= ld->Rdbfr+VIDEO_BUFFER_SIZE)
            Fill_Buffer();
        ld->Bfr |= *ld->Rdptr++ << (24 - Incnt);
        Incnt += 8;
    }
    
    ld->Incnt = Incnt;
    
#ifdef VERIFY 
    ld->Bitcnt += 32;
#endif /* VERIFY */
}


unsigned int Get_Bits32()
{
    unsigned int l;
    
    l = Show_Bits(32);
    Flush_Buffer32();
    
    return l;
}
