/* 
 *  RunState.h 
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#ifndef RUN_STATE_H
#define RUN_STATE_H

#include ".\flaskmpeg.h"
#include ".\plugins.h"
#include ".\PostProcessing.h"
#include ".\video\videowrapper.h"
#include ".\audio\audio.h"
#include ".\Language.h"
#include ".\Misc\Graph.h"
#include ".\Profile.h"
#include ".\mism.h"
#include ".\batchlist.h"
#include ".\OutputManager.h"
#include ".\VideoRenderer.h"

enum { FILE_MODE, DVDMODE };

struct TRunState
{
  TPPost            pp;
  int	              audioType[8];
  int			          nAudioTracks;
  int               selected_out_plug;
  int               working_mode;
  i64               startFilePos;
  char              openedFileName[MAXFILENAME];
  
  batchlist         vBatchList;

  HWND              hMainWnd;
  HWND              hPlayerWnd;
 
  HINSTANCE         hInst;
  
  CProfile          *profiler;    // Profiler
  TProfile           prof;        // Profile currectly selected
  
  TWorkingMism      pVideoMism;
  TWorkingMism      pAudioMism;
  
  COutputManager    obOutputManager;

  VideoWrapper      *video;
  Audio			        *audio;

  TAudioTrack       sAudioTrack;  // Audio Track currently in use
  fmStreamIds       sStreamIds;   // Stream Ids from opened Mism
  
  CVideoRenderer    *pVideoRenderer;
  
  CLanguage         *lng;
  
  TPlugins          plugs;
  TGraph            gr;			// Progress graph stuff
  
  CArr<FMMismInfo>     AvalInputs; // Array of available MISMS
};


#endif