/* 
 *  resizer.h - Original code from Avery Lee's Virtual Dub
 *
 *	Copyright (C) Alberto Vigata - ultraflask@yahoo.com - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#ifndef RESIZER_H
#define RESIZER_H

enum {
	FILTER_NONE				= 0,
	FILTER_BILINEAR			= 1,
	FILTER_BICUBIC			= 2,
	FILTER_TABLEBILINEAR	= 3,
	FILTER_TABLEBICUBIC		= 4,
};

void PrepareResizer(int oxsize, int oysize, bool doAR ,double iDAR, int filterMode, VBitmap *source);
void UnPrepareResizer();
void ResizerRun(VBitmap *source, VBitmap *dest);
/*
int resize_start(MyFilterData *mfd, VBitmap *src);
int resize_run(MyFilterData *mfd, VBitmap *source, VBitmap *dest);
int resize_stop(MyFilterData *mfd);
*/

#endif

