/* 
 *  misc.h   - Original code from Avery Lee's Virtual Dub
 *
 *	Copyright (C) Alberto Vigata - ultraflask@yahoo.com - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#ifndef f_VIRTUALDUB_MISC_H
#define f_VIRTUALDUB_MISC_H

#include <mmsystem.h>
long __declspec(naked) MulDivTrunc(long a, long b, long c) {
	__asm {
		mov eax,[esp+4]
		imul dword ptr [esp+8]
		idiv dword ptr [esp+12]
		ret
	}
}
int NearestLongValue(long v, const long *array, int array_size);

// only works properly when d1,d2>0!!

long inline int64divto32(__int64 d1, __int64 d2) {
	return d2?(long)((d1+d2/2)/d2):0;
}

__int64 inline int64divround(__int64 d1, __int64 d2) {
	return d2?((d1+d2/2)/d2):0;
}

__int64 inline int64divroundup(__int64 d1, __int64 d2) {
	return d2?((d1+d2-1)/d2):0;
}

bool isEqualFOURCC(FOURCC fccA, FOURCC fccB);

#endif
