/* 
 *  Resize.h 
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#if !defined(AFX_RESIZE_H__D118E4A5_A507_11D3_8C3D_00000100CF13__INCLUDED_)
#define AFX_RESIZE_H__D118E4A5_A507_11D3_8C3D_00000100CF13__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000



#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <math.h>

#define M_PI 3.14159265358979311
#define CLAMP(A) ((A)<=(0) ? (0) : (A)<=(255) ? (A) : (255))
#define SAR(DAR,hor,vert) (DAR*((double)hor/(double)vert))


#define  WEIGHT_SCALE (int)32767



// YUV to RGB conversion constants
#define CRV (int)117504
#define CBU (int)138453
#define CGU (int)13954
#define CGV (int)34903

// Contribution struct
typedef struct {
	int	    pixel;
	double  weight;
	short	weightShort;
} CONTRIB;


// List of contributions for a given pixel
typedef struct {
	int	n;		    /* number of contributors */
	CONTRIB	*p;		/* pointer to list of contributions */
} CLIST;



#ifndef EXIT_SUCCESS
#define	EXIT_SUCCESS	(0)
#define	EXIT_FAILURE	(1)
#endif

typedef	unsigned char	Pixel;


#define	WHITE_PIXEL	(255)
#define	BLACK_PIXEL	(0)


typedef struct YUVImageTag
{
	unsigned char *Y;
	int			  Yxsize;
	int			  Yysize;
	unsigned char *U;
	unsigned char *V;
	int			  Cxsize;
	int			  Cysize;
} YUVimage;

typedef struct {
	int	xsize;		/* horizontal size of the image in Pixels */
	int	ysize;		/* vertical size of the image in Pixels */
	Pixel *	data;   /* pointer to first scanline of image */
	int	span;		/* byte offset between two scanlines */
} Image;

class CResize  
{
public:
	Init(   int   filter,
			int   oxsize,
			int   oysize);	
	CResize();
	~CResize();


	int Crop(Pixel *image, Pixel *dispImage, int ixsize,int iysize,int topCrop,int bottomCrop);
	ResRGBtoRGBA(  Image  *src, Pixel  *dst,Pixel  *dispimage);
	ResYUVtoRGBA(YUVimage *src, Pixel  *dst,Pixel  *dispimage);
	ResYUVtoRGBA_AR(YUVimage  *inp , Pixel  *dst,Pixel  *dispimage, bool doAR ,double iDAR);
private:
			DeAllocateContrib(CLIST *contrib,int size);
	CLIST * AllocateContrib(int size);
			WorkOutContributions(CLIST *contrib,int isize, int osize);

	int   oxsize;			/* output x size  */
	int   oysize;

	int	   filter;	        		/* filter type */
	double (*filterf)(double);		/* pointer to filter function */
	double fwidth;					/* filter width. Taps of filter */	
 	
};

#endif // !defined(AFX_RESIZE_H__D118E4A5_A507_11D3_8C3D_00000100CF13__INCLUDED_)
