/* 
 *  ProgressDlg.h
 *
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#if !defined(AFX_PROGRESSDLG_H__F55B2A0F_D696_4C8F_91FE_BBB67B2E5A59__INCLUDED_)
#define AFX_PROGRESSDLG_H__F55B2A0F_D696_4C8F_91FE_BBB67B2E5A59__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "flasktypes.h"

// Priorities
#define IDLE_PRIO	 0
#define NORMAL_PRIO  1
#define HIGH_PRIO    2
#define HIGHEST_PRIO 3


#ifndef PURE
#define PURE =0
#endif 


// Class that supports progress tracking.
class CProgressTracking
{
public:
  virtual ui32 GetPresentFrame() PURE;
  virtual void Cancel() PURE;
  virtual void Pause() PURE;
  virtual void Resume() PURE;
  virtual bool Terminated() PURE;
  virtual bool IsPaused() PURE;
  virtual char *GetOutputFileName() PURE;
  virtual ui64 GetProcessed() PURE;
  virtual ui64 GetSize() PURE;
  virtual ui32 GetJobCount() PURE;
  virtual ui32 GetJobInProcess() PURE;
  virtual void SetProgressPriority(ui32 nPriority) PURE;
  
};

LRESULT CALLBACK ProgressDlg(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);

#endif // !defined(AFX_PROGRESSDLG_H__F55B2A0F_D696_4C8F_91FE_BBB67B2E5A59__INCLUDED_)
