/* 
 *  ProgressDlg.cpp
 *
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include <windows.h>
#include "ProgressDlg.h"
#include "RunState.h"
#include "flaskmpeg.h"
#include ".\Misc\StatsStrings.h"
#include "resource.h"
#include "auxiliary.h"
#include ".\Demux\demux.h"

extern TRunState rs;
extern TConfig   o; 
extern HWND hMainWnd;
extern void EnableAllMenu();
extern void ShowPlayer();

char				*chars="-\\|/-\\|/";


void SetPriority(CProgressTracking *pProgress, int prio){
  switch (prio){
		case IDLE_PRIO:
      pProgress->SetProgressPriority( THREAD_PRIORITY_IDLE);
      break;
    case NORMAL_PRIO:
      pProgress->SetProgressPriority( THREAD_PRIORITY_NORMAL);
      break;
    case HIGH_PRIO:
      pProgress->SetProgressPriority(THREAD_PRIORITY_HIGHEST);
      break;
    case HIGHEST_PRIO:
      pProgress->SetProgressPriority( THREAD_PRIORITY_TIME_CRITICAL);
      break;
  }
}

void InitStrings(HWND hDlg)
{
  TStatsStrings stats;
  char szTemp[1024];

  RenderStatsStrings(&stats);		

  // Use the a pointer to the base of the decoders to retrieve statistics
  CDemux *demux;
  // if we have video use it for statistics
  if( rs.video )
    demux = rs.video;
  else
    demux = rs.audio;

  //Process information
  //input
  DlgSetText(hDlg, IDC_IVIDEOFORMAT, stats.InMedia.video_format);
  DlgSetText(hDlg, IDC_IVIDEORES,    stats.InMedia.video_size);
  DlgSetText(hDlg, IDC_IFRAMERATE,   stats.InMedia.video_frame_rate);
  DlgSetText(hDlg, IDC_IVIDEOSTRUCT, stats.InMedia.video_structure);
  
  sprintf( szTemp, "%s", demux->GetFileName() );        
  DlgSetText(hDlg, IDC_IFILE, szTemp);        

  DlgSetText(hDlg, IDC_IAUDIOFORMAT, stats.InMedia.audio_format);
  DlgSetText(hDlg, IDC_IAUDIOFREQ,   stats.InMedia.audio_sample_freq);
  DlgSetText(hDlg, IDC_IAUDIOBITRATE,stats.InMedia.audio_bit_rate);
  DlgSetText(hDlg, IDC_IAUDIOMODE,   stats.InMedia.audio_channels);
  

  // OUTPUT
  DlgSetText(hDlg, IDC_OVIDEOFORMAT, stats.OutMedia.video_format);
  DlgSetText(hDlg, IDC_OVIDEORES,    stats.OutMedia.video_size);
  DlgSetText(hDlg, IDC_OFRAMERATE,   stats.OutMedia.video_frame_rate);
  //DlgSetText(hDlg, IDC_OVIDEOSTRUCT, stats.OutMedia.video_structure);
          
  DlgSetText(hDlg, IDC_OFILE, rs.prof.outputFile);        
  
  DlgSetText(hDlg, IDC_OAUDIOFORMAT, stats.OutMedia.audio_format);
  DlgSetText(hDlg, IDC_OAUDIOFREQ,   stats.OutMedia.audio_sample_freq);
  DlgSetText(hDlg, IDC_OAUDIOBITRATE,stats.OutMedia.audio_bit_rate);
  DlgSetText(hDlg, IDC_OAUDIOMODE,   stats.OutMedia.audio_channels);

}

// Mesage handler for about box.
LRESULT CALLBACK ProgressDlg(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  double porciento;
  char szTemp[MAX_PATH];
  static UINT				progressTimer;
  static char temp_filename[MAX_PATH];
  static CProgressTracking *pProgress;
  static int i,j,k,w,h;
  static DWORD remaining_time,present_time,elapsed_time,start_time;
  static __int64  startPos=0;
  RECT rc;		
  static TStatsStrings stats;      //This is a big one
  static unsigned start_mpeg_time;
  static nDetailsHeight, nCompactHeight, nDlgWidth;
  
  switch (message)
  {
		case WM_SYSCOMMAND:
    /*			if(wParam==SC_MINIMIZE)
				SendMessage(hMainWnd, WM_SYSCOMMAND, SC_MINIMIZE, 0);
        if(wParam==SC_RESTORE)
      SendMessage(hMainWnd, WM_SYSCOMMAND, SC_RESTORE, 0);*/
      break;
    case WM_TIMER:

      if(!pProgress->IsPaused())
      {   
        // Use the a pointer to the base of the decoders to retrieve statistics
        CDemux *demux;
        // if we have video use it for statistics
        if( rs.video )
          demux = rs.video;
        else
          demux = rs.audio;
        
        sprintf( szTemp, "%s", demux->GetFileName() );
        DlgSetText(hDlg, IDC_IFILE, szTemp);
        DlgSetText(hDlg, IDC_OFILE, pProgress->GetOutputFileName() );    
        // Graph
        if(rs.plugs.outPlugs[rs.selected_out_plug].fileType == VXXtype)
          DrawGraph(hDlg, &rs.gr);
        
        if(!rs.prof.compileWhole)	// Frames specified
        {
          porciento= ((double)pProgress->GetPresentFrame()/(double)rs.prof.framesToCompile)*100.0;
          SendDlgItemMessage( hDlg, IDC_PROGRESS1, PBM_SETPOS, (ui32)porciento , 0);
          if( pProgress->GetPresentFrame() <2 && i<200){
            i++;
            strcpy( szTemp, "Starting Up ..");
            for(j=1; j<=i; j++){
              strcat(szTemp, "..");
            }
            SetDlgItemText( hDlg, IDC_FRAMENO, szTemp);
          }
          else{
            sprintf(szTemp, "Processing frame %d of %d ", pProgress->GetPresentFrame(), rs.prof.framesToCompile);
            SetDlgItemText( hDlg, IDC_FRAMENO, szTemp);
          }
        }
        else	//Compile whole file
        {
          porciento= ((double)(i64)pProgress->GetProcessed() /(double)(i64)(pProgress->GetSize()))*100.0;
          SendDlgItemMessage( hDlg, IDC_PROGRESS1, PBM_SETPOS, (ui32)porciento , 0);			
          if( pProgress->GetPresentFrame() <2 && i<1000)
          {
            i++;
            strcpy( szTemp, "Starting Up .");
            for(j=1; j<=i; j++){
              strcat(szTemp, ".");
            }
            SetDlgItemText( hDlg, IDC_FRAMENO, szTemp);
          }
          else{
            // set startpos to the position where we actually start reading,
            // which might be a lot higher than 0
            if (startPos == 0) { // first time we get here
              startPos = demux->GetStreamPos();
              start_mpeg_time = rs.video->time;
            }
            char tempstr[32];
            MillisecondsToTime(tempstr, rs.video->time - start_mpeg_time);
            sprintf(szTemp, "Processing frame %d (%s)", pProgress->GetPresentFrame(), tempstr);
            SetDlgItemText( hDlg, IDC_FRAMENO, szTemp);
          }
          
        }
        
        sprintf(szTemp, "Processing job %d of %d", pProgress->GetJobInProcess()+1, pProgress->GetJobCount());
        DlgSetText( hDlg, IDC_JOBTEXT, szTemp );

        sprintf(szTemp, "%.03lf %%", porciento);
        SetDlgItemText( hDlg, IDC_PERCENT, szTemp);
        // Pilla tiempo actual
        if(pProgress->GetPresentFrame() == 0)
          start_time=GetTickCount();
        present_time=GetTickCount();
        //Duracion simulacion
        MillisecondsToTime( szTemp, elapsed_time=present_time-start_time);
        strcat(szTemp, " (");
        LocalTimePlusMilliseconds(szTemp + strlen(szTemp), 0, false);
        strcat(szTemp, ")");
        SetDlgItemText( hDlg, IDC_ELAPSED, szTemp);
        // FPS
        if(elapsed_time){
          sprintf(szTemp, "%.2lf", 1000.0*((double)pProgress->GetPresentFrame())/((double)elapsed_time) );
          DlgSetText( hDlg, IDC_FPS, szTemp);
        }
        //Tiempo restante
        remaining_time= (DWORD)((100.0-porciento)/porciento*(double)elapsed_time);
        MillisecondsToTime( szTemp, remaining_time);
        strcat(szTemp, " (");
        LocalTimePlusMilliseconds(szTemp + strlen(szTemp), remaining_time, false);
        strcat(szTemp, ")");
        SetDlgItemText( hDlg, IDC_REMAINING, szTemp);
        sprintf( szTemp, "FlasK Encoding %d%% %c ", (int)porciento, chars[k++%8]);
        SetWindowText((HWND)hMainWnd, szTemp);

    }
    if(pProgress->Terminated())
      SendMessage( hDlg, WM_COMMAND, MAKEWPARAM(IDOK,0), 0);

    break;
    case WM_INITDIALOG:
      // Get the progress tracking object
      pProgress = (CProgressTracking *)lParam;

      // Graph init
      GraphStart(&rs.gr);
      
      //Set combo box to normal and set
      SendDlgItemMessage(hDlg, IDC_PRIO, CB_ADDSTRING, 0, (LPARAM) "Idle");
      SendDlgItemMessage(hDlg, IDC_PRIO, CB_ADDSTRING, 0, (LPARAM) "Normal");
      SendDlgItemMessage(hDlg, IDC_PRIO, CB_ADDSTRING, 0, (LPARAM) "High");
      SendDlgItemMessage(hDlg, IDC_PRIO, CB_ADDSTRING, 0, (LPARAM) "Highest");
      SendDlgItemMessage(hDlg, IDC_PRIO, CB_SETCURSEL, 1, 0);
      SetPriority( pProgress, NORMAL_PRIO );
      
      if(o.options.displayVideo)
        SendDlgItemMessage( hDlg, IDC_DISPLAYOUTPUT, BM_SETCHECK, BST_CHECKED ,0);
      else
        SendDlgItemMessage( hDlg, IDC_DISPLAYOUTPUT, BM_SETCHECK, BST_UNCHECKED ,0);
      
      i=0;
      
      start_time=GetTickCount();
      start_mpeg_time = 0;
      startPos = rs.video->GetStreamPos();
      strcpy(temp_filename, rs.prof.outputFile);
//      add_file_ext(temp_filename);
      progressTimer= SetTimer(hDlg,       // handle of window for timer messages
                              1,          // timer identifier
                              500,        // time-out value
                              NULL   // address of timer procedure
                              );
      InitStrings(hDlg);

      GetWindowRect(hDlg, &rc);
      w = rc.right - rc.left;
      h = rc.bottom - rc.top;
      nDetailsHeight = h;
      if(rs.plugs.outPlugs[rs.selected_out_plug].fileType != VXXtype)
        nDetailsHeight = (int)(h*0.80);

      nCompactHeight = h *0.30;
      nDlgWidth = w;

      WindowResize( hDlg, w, nDetailsHeight);
      return TRUE;
      
    case WM_COMMAND:
      
      if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
      {
        // Cancel
        if(!pProgress->Terminated())
          pProgress->Cancel();

        // Process the rest
        SetWindowText((HWND)hMainWnd, "FlasKMPEG");
        KillTimer( hDlg, 1);
        EnableAllMenu();
        EndDialog(hDlg, LOWORD(wParam));
        ShowPlayer();
        //And turndown computer if suitable
        if(rs.prof.shutdown && (o.options.presentFrame >= 1000))
          ExitWindowsEx( EWX_SHUTDOWN, 0); 
        return TRUE;

      } 
      switch(LOWORD(wParam))
      {
      case IDC_PRIO:
        if(HIWORD(wParam)==CBN_SELCHANGE)
          SetPriority( pProgress, SendDlgItemMessage(hDlg, IDC_PRIO, CB_GETCURSEL, 0,0) );
        break;
      case IDC_PAUSE:
        if(pProgress->IsPaused())
        {
          pProgress->Resume();
          DlgSetText(hDlg, IDC_PAUSE, "&Pause");
        }
        else{
          pProgress->Pause();
          DlgSetText(hDlg, IDC_PAUSE, "&Resume");
        }
        break;
      case IDC_DISPLAYOUTPUT:
        if(o.options.displayVideo)
          o.options.displayVideo=false;
        else
          o.options.displayVideo=true;
        break;
      case IDC_DETAILS:
        if(strcmp(DlgGetText(hDlg, IDC_DETAILS, szTemp), "&Details <<")==0)
        {
          WindowResize(hDlg, nDlgWidth, nCompactHeight);
          DlgSetText(hDlg, IDC_DETAILS, "&Details >>");
        }
        else
        {
          WindowResize(hDlg, nDlgWidth, nDetailsHeight);
          DlgSetText(hDlg, IDC_DETAILS, "&Details <<");          
        }
        break;
      }
      
      break;
      
  }
  return FALSE;
}
