/* 
 *  Profile.cpp 
 *
 *	Copyright (C) Alberto Vigata - July 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
 

#include <windows.h>
#include "Profile.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CProfile::CProfile(char *program_directory)
{
    n_selected = 0;
    if(program_directory)
        strcpy(this->program_directory, program_directory);
}

CProfile::~CProfile()
{

}

int CProfile::LoadProfileFromDisk(char *fileName)
{
    FILE *input_profile;
    TProfile *myProfile;

    // Open file with this name
    if(!(input_profile=fopen(fileName, "rb")) )
        return 0;
    // create temporary profile
    myProfile = (TProfile *)malloc( sizeof(TProfile) );

    // Load profile from disk
    if( fread( myProfile, 1, sizeof(TProfile), input_profile ) != sizeof(TProfile) )
    {
        free(myProfile);
        fclose(input_profile);
        return 0;
    }
    // If the profile version doesnt match with this version, drop it
    if(myProfile->nProfileVersion!=PROFILE_VERSION)
    {
      free(myProfile);
      fclose(input_profile);
      return 0;
    }
    // Add profile to our profile list
    profiles.AddItem( myProfile );
    
    fclose(input_profile);
    free(myProfile);
    return 1;
}

// Refresh: Load all available profiles from disk
int CProfile::Refresh()
{
	WIN32_FIND_DATA find_data;
	char     directory[MAX_PATH], szTemp[MAX_PATH];
	HANDLE   search_handle;
	int      i;

    sprintf(directory, "%s\\Profiles\\*.profile.flask", program_directory );
	
    profiles.EmptyArray();

	i=0;
	search_handle = FindFirstFile(directory, &find_data);
	if(search_handle==INVALID_HANDLE_VALUE){
		profiles.EmptyArray();
	}
	else{
        sprintf(szTemp,"%s\\Profiles\\%s", program_directory, find_data.cFileName );
		LoadProfileFromDisk( szTemp );

        while( FindNextFile(search_handle, &find_data ) ){
            sprintf(szTemp,"%s\\Profiles\\%s", program_directory, find_data.cFileName );
            LoadProfileFromDisk( szTemp );
		}
		FindClose(search_handle);
	}

    n_selected = 0;
    return profiles.GetCount();
}

int CProfile::AddProfile(TProfile *profile_data )
{
	char szTemp[MAX_PATH];
	FILE *file;

    if(!profile_data)
        return 0;

  profile_data->nProfileVersion = PROFILE_VERSION;

	strcpy(szTemp, program_directory);
	strcat(szTemp,"\\Profiles" );
	//Creating Profiles folder
	CreateDirectory(szTemp, NULL);

	sprintf(szTemp, "%s\\%s.profile.flask", szTemp, profile_data->profile_name );
	if(!(file=fopen(szTemp, "wb"))){
		//Ooops
		return 0;
	}
	else
	{
		fwrite( profile_data, sizeof(TProfile), 1, file);
		fclose(file);
        // Now, reload profiles
		return Refresh();
	}
}

int CProfile::DeleteProfile(int profileIndex)
{
    char szTemp[MAX_PATH];

    // Cant delete profile 0
    if( profileIndex <=0 || profileIndex > (profiles.GetCount()-1) )
        return NULL;

	sprintf(szTemp, "%s\\Profiles\\%s.profile.flask", program_directory, profiles[profileIndex].profile_name );
    DeleteFile(szTemp);
    return Refresh();
}

int CProfile::GetCount()
{
    return profiles.GetCount();
}
    
TProfile * CProfile::Get( int profileIndex)
{
    if( profileIndex <0 || profileIndex > (profiles.GetCount()-1) )
        return NULL;
    return &profiles[profileIndex];
}

TProfile * CProfile::GetSelected()
{
    return &profiles[n_selected];
}

int CProfile::GetSelectedIndex()
{
    return n_selected;
}

int CProfile::Select(int profileIndex)
{
    if( profileIndex <0 || profileIndex > (profiles.GetCount()-1) )
        return NULL;
    n_selected = profileIndex;
    return 1;
}

bool CProfile::IsDefault()
{
  return strcmp(profiles[n_selected].profile_name, "Default")==0;
}

TProfile *CProfile::GetDefault()
{
  for( int i=0; i<profiles.GetCount(); i++ )
  {
    if( strcmp(Get(i)->profile_name, "Default")==0 )
      break;
  }
  if( i >= profiles.GetCount() )
    i--;
  return Get(i);
}

int CProfile::GetDefaultIndex()
{
  for( int i=0; i<profiles.GetCount(); i++ )
  {
    if( strcmp(Get(i)->profile_name, "Default")==0 )
      break;
  }
  if( i >= profiles.GetCount() )
    i--;
  return i;
}

void CProfile::SelectDefault()
{
  Select( GetDefaultIndex() );
}
