/* 
 *  PostProcessing.h
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#ifndef POST_PROCESSING_H
#define POST_PROCESSING_H

#include ".\profile.h"
#include ".\resizer\vbitmap.h"
#include ".\framesource.h"

struct TPPost
{
	// Original image
	int					inputW;
	int					inputH;
	// Resizing
	BOOL				doAR;
	double				iDAR;
	int					filterMode;
	int					resWidth;
	int					resHeight;
	
	// Crop and letterboxing
	BOOL				crop;
	int					cropTopOffset;
	int					cropHeight;
	int					cropLeftOffset;
	int					cropWidth;

	BOOL				letterbox;
	int					letterboxTop;
	int					letterboxBottom;
	int					letterboxLeft;
	int					letterboxRight;

	// Deinterlacing
	BOOL                deinterlace;
	int                 threshold;
	int                 blend_fields;

	// Current time to be used in subtitles stamping
	i64                 myClock;


};

#define  PPOST_WIDTH(x) (x.crop ? x.cropWidth : x.resWidth)
#define PPOST_HEIGHT(x) (x.crop ? x.cropHeight : x.resHeight)

int PostProcess(CFrame *pFrameSrc, CFrame *pFrameDst, TPPost *pp);
int PostProcessingStart(VBitmap *source, VBitmap *dest, TPPost *pp);
int PostProcess(VBitmap *source, VBitmap *dest, TPPost *pp);
int PostProcessingStop(TPPost *pp);

void FromPPostToConfig( TProfile *prof, TPPost *pp);
void FromConfigToPPost( TProfile *prof, TPPost *pp);

int CheckVideoParameters(TPPost *pp);
#endif