/* 
 *  Plugins.cpp
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include <windows.h>
#include "flaskmpeg.h"
#include "plugins.h"
#include ".\Premiere\Premiere.h"

char load_directory[MAX_PATH];
compStdParms		stdParms;
compInfoRec				infoRec;			            //Retrieves info from plugin
compFileInfoRec			fileInfoRec;		            //Retrieves supported formats
compAudioInfoRec        audioInfoRec;

//	callbacks
compCallbackFuncs   callbackFuncs;      //Callback functions from the plugin
ClassDataFuncs		classFuncs;
compAudioFuncs		audioFuncs;
compVideoFuncs		videoFuncs;
compMemoryFuncs		memoryFuncs;
compProgressFuncs   progressFuncs;
compDebugFuncs      debugFuncs;
// piSuites and related callbacks
piSuites            SuitesFunctions;
	PlugMemoryFuncs PMMFunctions;
	PlugWindowFuncs PWIFunctions;
	PlugppixFuncs   PPXFuncs;
	PlugUtilFuncs   PUTFuncs;


//  Inits Premiere structures and Stubs
void InitPremiereCallbacks(void)
{
	//Premiere Memory functions

	//Class Functions
	classFuncs.setClassData=			fsetClassData;
	classFuncs.getClassData=			fgetClassData;

	//Audio Functions
	audioFuncs.getAudio=				fgetAudio;
	audioFuncs.getBlipMax=				fgetBlipMax;

	//Video Functions
	videoFuncs.getFrame=				fgetFrame;
	videoFuncs.getFrameInfo=			fgetFrameInfo;
	videoFuncs.histogramInit=			fhistogramInit;
	videoFuncs.histogramFree=			fhistogramFree;
	videoFuncs.histogramProcessPixels=	fhistogramProcessPixels;
	videoFuncs.histogramToPalette=		fhistogramToPalette;
	videoFuncs.histogramDisposePalette=	fhistogramDisposePalette;
	videoFuncs.histogramReducePixels=	fhistogramReducePixels;

	//Memory Functions
	memoryFuncs.newPtr=					fnewPtr;
	memoryFuncs.setPtrSize=				fsetPtrSize;
	memoryFuncs.getPtrSize=				fgetPtrSize;
	memoryFuncs.disposePtr=				fdisposePtr;

	//Fucking Progress Functions (not docced)
	progressFuncs.setProgressStr=		fsetProgressStr;
	progressFuncs.updateProgress=		fupdateProgress;

	// Debuggin
	debugFuncs.debugStr         =       fdebugStr;
	debugFuncs.startDebug       =       fstartDebug;

	SuitesFunctions.piInterfaceVer  =  COMPILEMOD_VERSION_1;

	PMMFunctions.newPtr         = fnewPtr;
	PMMFunctions.setPtrSize     = f2setPtrSize;
	PMMFunctions.getPtrSize     = fgetPtrSize;
	PMMFunctions.disposePtr     = fdisposePtr;
	PMMFunctions.newHandle      = fnewHandle;
	PMMFunctions.setHandleSize  = fsetHandleSize;
	PMMFunctions.getHandleSize  = fgetHandleSize;
	PMMFunctions.disposeHandle  = fdisposeHandle;
		SuitesFunctions.memFuncs   = &PMMFunctions;

	memset(&PWIFunctions,1,sizeof(PlugWindowFuncs));
	PWIFunctions.updateAllWindows = fupdateAllWindows;
	PWIFunctions.getMainWnd       = fgetMainWnd;
		SuitesFunctions.windFuncs  =  &PWIFunctions;

	memset(&PPXFuncs,2,sizeof(PlugppixFuncs));
		PPXFuncs.ppixGetPixels   = fppixGetPixels;
		PPXFuncs.ppixGetBounds   = fppixGetBounds;
		PPXFuncs.ppixGetRowbytes = fppixGetRowbytes;
		SuitesFunctions.ppixFuncs = &PPXFuncs;
	
	memset(&PUTFuncs, 3, sizeof(PlugUtilFuncs));
		PUTFuncs.getSettings = fgetSettings;
		SuitesFunctions.utilFuncs = &PUTFuncs;
	// Asignations
	callbackFuncs.classFuncs=&classFuncs;
	callbackFuncs.audioFuncs=&audioFuncs;
	callbackFuncs.videoFuncs=&videoFuncs;
	callbackFuncs.memoryFuncs=&memoryFuncs;
	callbackFuncs.progressFuncs=&progressFuncs;
	callbackFuncs.debugFuncs     =&debugFuncs;
};


int SaveSettings(TPlugins *plugs, int current, char *name){
	char szTemp[1024];
	FILE *file;


	strcpy(szTemp, load_directory);
	strcat(szTemp,"\\Settings" );
	//Creating settings folder
	CreateDirectory(szTemp, NULL);

	sprintf(szTemp, "%s\\%s.settings.flask", szTemp,name);
	if(!(file=fopen(szTemp, "wb"))){
		//Ooops
		return 0;
	}
	else
	{
		fwrite( plugs->outPlugs[current].settings, OUT_PLUG_MEM, 1, file);
		fclose(file);
		return 1;
	}
}
int FlushPluginSettings( TPlugins *plugs ){
	int i;
	for(i=0; i<plugs->OutPluginCount; i++){
		if(plugs->outPlugs[i].settings!=NULL)
			SaveSettings(plugs, i, plugs->outPlugs[i].ID);
	}
	return 0;
}
static int LoadSettings(TPlugins *plugs, int current, char *name)
{
	char szTemp[1024];
	FILE *file;

	sprintf(szTemp, ".\\Settings\\%s.settings.flask", name);
	if(!(file=fopen(szTemp, "rb"))){
		//The file didn't exist
		plugs->outPlugs[current].settings = NULL;
	}
	else
	{
		plugs->outPlugs[current].settings = (char *)malloc(OUT_PLUG_MEM);
		fread( plugs->outPlugs[current].settings, OUT_PLUG_MEM, 1, file);
		fclose(file);
	}
	return 1;
}
static int PluginStartup( TPlugins *plugs, char *filename ){

		int i;

		HINSTANCE			hinstLib; 
		int                 current = plugs->OutPluginCount;
		CompileEntryFunc	CompileEntry;



		hinstLib = LoadLibrary(filename); 
		// If the handle is valid, try to get the function address.
		if (!hinstLib)
			return 0;

		plugs->outPlugs[current].hinstLib = hinstLib;

		CompileEntry = (CompileEntryFunc) GetProcAddress(hinstLib, "xCompileEntry");
		if(!CompileEntry){
			FreeLibrary(hinstLib);
			plugs->outPlugs[current].hinstLib = NULL;
			return 0;
		}
		//iNIT Premiere callbacks
		InitPremiereCallbacks();

		//StdParms
		stdParms.compInterfaceVer=1;
		stdParms.funcs    =  &callbackFuncs;
		stdParms.piSuites =  &SuitesFunctions;

		if((CompileEntry)(compStartup, &stdParms, (long)&infoRec,0)!=comp_ErrNone){
		     // Free the DLL module.
			FreeLibrary(hinstLib);
			plugs->outPlugs[current].hinstLib = NULL;
			return 0;
		}
                plugs->outPlugs[current].CompilerID = infoRec.compilerID;
                plugs->outPlugs[current].fileType   = infoRec.fileType;
		strcpy( plugs->outPlugs[current].ID         , infoRec.compilerName );

				LoadSettings(plugs, current, infoRec.compilerName);
		//Now query for the supported formats
		i=0;
		while( (CompileEntry)(compGetIndFormat, &stdParms, (long)&fileInfoRec,i)!=comp_BadFormatIndex )
		{
			i++;
			if(fileInfoRec.subtype==compUncompressed)
				break;
		}//Just look for uncompressed data

		i=0;
		while( (CompileEntry)(compGetAudioIndFormat, &stdParms, (long)&audioInfoRec,i)!=comp_BadFormatIndex )
		{
			i++;
			if(fileInfoRec.subtype==compUncompressed)
				break;
		}

		//Plugin options buffer
/*					if( o.bufferExists[MPEG_PAN] ){
						FilePrefsRec[MPEG_PAN].compilerPrefs =(char *) malloc(2048);
						memcpy( FilePrefsRec[MPEG_PAN].compilerPrefs, o.buffer[MPEG_PAN] ,2048);
					}
					else
						FilePrefsRec[MPEG_PAN].compilerPrefs=NULL;
*/
		plugs->outPlugs[current].CompileEntry=CompileEntry;
		return ++plugs->OutPluginCount;
}

int LoadPlugins( TPlugins *plugs, char *program_directory )
{
	WIN32_FIND_DATA find_data;
	char            directory[MAX_PATH];
	HANDLE          search_handle;
	int i;
	int loaded_ok=0;

    if(!program_directory)
        return 0;

	// StartUp stuff
	for(i=0; i<MAX_OUT_PLUGINS; i++)
	{
		plugs->outPlugs[i].hinstLib = NULL;
	}
	
	// try flaskmpegpeasopeich.dll for compatibility
	if(PluginStartup( plugs,  "flaskmpegpeasopeich.dll" ))
			loaded_ok++;

	strcpy( load_directory, program_directory);	
	sprintf(directory, "%s\\*.cm.flask", load_directory);

	i=0;
	search_handle = FindFirstFile(directory, &find_data);
	if(search_handle==INVALID_HANDLE_VALUE){
		return loaded_ok;
	}
	else{
		if(PluginStartup( plugs,  find_data.cFileName ))
			loaded_ok++;

		while( FindNextFile(search_handle, &find_data ) ){
			if(PluginStartup( plugs,  find_data.cFileName ))
				loaded_ok++;
		}
		FindClose(search_handle);
	}

	return loaded_ok;
}

int ClosePlugins(TPlugins *plugs)
{
	int i;
	for(i=0; i<plugs->OutPluginCount; i++)
	{
		FreeLibrary(plugs->outPlugs[i].hinstLib);
		if(plugs->outPlugs[i].settings)
			free(plugs->outPlugs[i].settings);
	}
	return 0;
}