/* 
 *  Player.h
 *
 *	Copyright (C) Alberto Vigata - July 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#include "FlasKMPEG.h"
#include "thread.h"
#include ".\video\videowrapper.h"

// Create worker thread for the player
class CPlayerThread : public CFlThread
{
public:
    //Constructor
    CPlayerThread::CPlayerThread( VideoWrapper *pVideoDecoder, HANDLE hMainWnd){
        m_pVideoDecoder = pVideoDecoder;
        m_hMainWnd = hMainWnd;
        m_lPlayFrameCount = 0;
        m_nCommand = seekBeginning;
    };

    void Seek(ui64 nSeekPos)
    {
      {
        CFlAutoLock commandLock(&m_csCommand);
      
        m_nCommand = seek;
        m_nParam   = nSeekPos;
        m_evCommandCompleted.Reset();
        m_evCommandTrigger.Set();
      }
      m_evCommandCompleted.Wait();
    }
    void SeekKeyFrame(ui64 nSeekPos)
    {
      CFlAutoLock commandLock(&m_csCommand);
      m_nCommand = seekKeyFrame;
      m_nParam   = nSeekPos;
      m_evCommandTrigger.Set();
    }
    void SeekBeginning(){
        CFlAutoLock commandLock(&m_csCommand);
        m_nCommand = seekBeginning;
        m_evCommandTrigger.Set();
    };
    void SeekEnd(){
        CFlAutoLock commandLock(&m_csCommand);
        m_nCommand = seekEnd;
        m_evCommandTrigger.Set();
    };
    void NextFrame(){
        CFlAutoLock commandLock(&m_csCommand);
        m_nCommand = nextFrame;
        m_evCommandTrigger.Set();        
    };
    void PrevFrame(){
        CFlAutoLock commandLock(&m_csCommand);
        m_nCommand = prevFrame;
        m_evCommandTrigger.Set();
    }
    void NextKeyFrame()
    {
        CFlAutoLock commandLock(&m_csCommand);
        m_nCommand = nextKeyFrame;
        m_evCommandTrigger.Set();
    }
    void PrevKeyFrame()
    {
        CFlAutoLock commandLock(&m_csCommand);
        m_nCommand = prevKeyFrame;
        m_evCommandTrigger.Set();
    }
    void FastForward(){
        CFlAutoLock commandLock(&m_csCommand);
        m_nCommand = fastForward;
        m_evCommandTrigger.Set();
    }
    void FastRewind(){
        CFlAutoLock commandLock(&m_csCommand);
        m_nCommand = fastRewind;
        m_evCommandTrigger.Set();
    }
    void Play(){
        CFlAutoLock commandLock(&m_csCommand);
        m_nCommand = play;
        m_evCommandTrigger.Set();
    }
    void PlayBack(){
      CFlAutoLock commandLock(&m_csCommand);
      m_nCommand = playBack;
      m_evCommandTrigger.Set();
    }
    void Stop(){
        CFlAutoLock commandLock(&m_csCommand);
        m_nCommand = stop;
        m_evCommandTrigger.Set();
    }
    ui64 GetFrameStartPos()
    {
      {
        CFlAutoLock commandLock(&m_csCommand);
        m_nCommand = getFrameStartPos;
        m_evCommandCompleted.Reset();
        m_evCommandTrigger.Set();
      }
      m_evCommandCompleted.Wait();
      return m_nCommandResult;
    }
    // Stops the playing thread. This methods
    // blocks until it is finished.
    void Destroy(){
      m_evFinish.Reset();
      //Open scope for locking the command
      {
        CFlAutoLock commandLock(&m_csCommand);
        m_nCommand = exit;
        m_evCommandTrigger.Set();
      }
      // Now just wait for the event
      m_evFinish.Wait();
    }

    enum playerStates 
    {
      stStopped, stPlaying, stPlayingBack, stNextFrame, stPrevFrame, stNextKeyFrame,
        stPrevKeyFrame, stFastForward, stFastRewind
    };
    
    playerStates GetState(){return m_nState;}
    LONG GetPlayFrameCount(){ return m_lPlayFrameCount; }

private: 

    enum playerCommands
    {
        noCommand, seek, seekKeyFrame, seekBeginning, seekEnd, nextFrame,
        prevFrame, nextKeyFrame, prevKeyFrame, 
        fastForward, fastRewind, getFrameStartPos ,play, playBack, stop, exit
    };
    HANDLE m_hMainWnd;
    CFlCritSec  m_csCommand;
    CFlEvent    m_evCommandTrigger;
    CFlEvent    m_evCommandCompleted;
    CFlEvent    m_evFinish;
    // Actual running thread
    DWORD ThreadProc();
    VideoWrapper  *m_pVideoDecoder;
    playerStates   m_nState;
    playerCommands m_nCommand;
    ui64           m_nParam;
    ui64           m_nCommandResult;
    LONG           m_lPlayFrameCount;


};

void ShowPlayer();
void HidePlayer();
LRESULT CALLBACK	PlayerDlg(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);