/* 
 *  OutputManager.h
 *
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#if !defined(AFX_OUTPUTMANAGER_H__4A6D4869_F64A_41A6_B12B_1B2A529DD8DF__INCLUDED_)
#define AFX_OUTPUTMANAGER_H__4A6D4869_F64A_41A6_B12B_1B2A529DD8DF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "thread.h"
#include "videosource.h"
#include "progressdlg.h"
#include "batchlist.h"


typedef struct tagTOutputManagerRunInfo
{
  batchlist *pJobList;
}TOutputManagerRunInfo;

class COutputManager:public CProgressTracking, public CFlThread
{
public:
  void ConfigureOutput(long nIndex);

  CVideoSource *GetSource(){ return m_pVideoSource; }
	COutputManager();
	virtual ~COutputManager();

  // The Run function
  bool Run( TOutputManagerRunInfo *pRunInfo );

  // Progress Tracking stuff
  void SetProgressPriority(ui32 nPriority)
  { 
    SetPriority(nPriority); 
    if(m_pVideoSource) m_pVideoSource->SetPriority(nPriority);
  }
  char *GetOutputFileName(){ return m_pFinalOutputFileName; }
  ui64 GetProcessed(){ return m_nConversionProcessed+m_nPartialProcessed; }
  ui64 GetSize(){ return m_nConversionSize; }
  ui32 GetJobCount(){ return m_oJobList.size(); }
  ui32 GetJobInProcess(){ return m_nJobInProcess; }
  ui32 GetPresentFrame() {return m_nFrameCount; }
  void Cancel(){ m_evResumeCompile.Set(); m_evCancelCompile.Set(); m_evCompileCanceled.Wait(); }
  void Pause(){ m_evResumeCompile.Reset(); m_evPauseCompile.Set(); }
  void Resume(){ m_evResumeCompile.Set(); }
  bool Terminated(){ return m_bTerminated; }
  bool IsPaused(){ return !m_bIsRunning; }

  // Premiere stubs inside output manager
  int fgetFrame ( long frame, 
                  void **buffer, 
                  long *rowbytes, 
                  compGetFrameReturnRec *getFrameReturn, 
                  char getCompressed, long compileSeqID );

  int fgetAudio ( long frame, 
                  long *frameCount, 
                  long *size, 
                  long offset, 
                  BufferReturnType theBuffer, 
                  long compileSeqID );

  // conversion variables
  i64 m_nMyClock;
  ui32 m_nFrameSpan;
  ui32 m_nAudPrevFrame;
  ui32 m_nAudSamplesPerFrame;
  bool m_bImageWaiting;
  bool m_bIsRunning;
  bool m_bTerminated;

  bool m_bFirstTime;

  // Some events
  CFlEvent m_evCompileCanceled;
  CFlEvent m_evCancelCompile;
  CFlEvent m_evPauseCompile;
  CFlEvent m_evResumeCompile;
  CFlEvent m_evCompileTerminated;
  
  ui32 m_nFrameCount;

  // Static
  CFrame *m_pFrameInProcess;
  
  CVideoSource *m_pVideoSource;
  compDoCompileInfo CompileInfo;

private:
  bool Start( ui64 nStart, ui64 nStop );
  void Stop();
  ui32 Convert();
  // Actual running thread
  DWORD ThreadProc();  
  char *AddFileExtension(char *);
  

  // conversion variables
  ui64 m_nConversionProcessed;
  ui64 m_nPartialProcessed;
  ui64 m_nConversionSize;
  ui32 m_nJobInProcess;
  ui32 m_nJobCount;
  // Used in get frame to update the conversion size
  ui64 m_nJobStartPos;

  TOutputManagerRunInfo m_sRunInfo;

  CListFrameBuffer *m_pDecodedFrameBuffer;
  char pOutputFileName[1024];
  char m_pFinalOutputFileName[1024];
  // Job list
  batchlist m_oJobList;
};

#endif // !defined(AFX_OUTPUTMANAGER_H__4A6D4869_F64A_41A6_B12B_1B2A529DD8DF__INCLUDED_)
