/* 
 *  IEEE1180Test.h
 *
 *	Copyright (C) Alberto Vigata - July 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#if !defined(AFX_IEEE1180TEST_H__894E2496_042A_464F_826F_5E579A46138B__INCLUDED_)
#define AFX_IEEE1180TEST_H__894E2496_042A_464F_826F_5E579A46138B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define DCTSIZE      (8)
#define DCTSIZE2     (DCTSIZE*DCTSIZE)

#define EIGHT_BIT_SAMPLES

#include <string>
using namespace std;

typedef short DCTELEM;		/* must be at least 16 bits */

typedef DCTELEM DCTBLOCK[DCTSIZE2];


class CIEEE1180Test  
{
public:
	CIEEE1180Test();
	virtual ~CIEEE1180Test();
  bool IsIEEE1180( void (* TestIdct)(DCTELEM *block) );
  int  GetProgress(){return m_nProgress;}
  const char *GetResults(){ return m_strResults.c_str(); }

private:
	bool Meets (double val, double limit);

	bool DoTest( long minpix, long maxpix, long sign, long niters, void (* TestIdct)(DCTELEM *block) );
	long IEEERand(long L, long H);
	void DCTInit();
	void RefInverseDCT( DCTELEM *block );
	void RefForwardDCT( DCTELEM *block );

  /* The cosine lookup table */
  /* coslu[a][b] = C(b)/2 * cos[(2a+1)b*pi/16] */
  double coslu[8][8];
  long sumerrs[DCTSIZE2];
  long sumsqerrs[DCTSIZE2];
  int maxerr[DCTSIZE2];

  // Format string
  char m_pTmpStr[1024];

  // String to store the reults.
  string m_strResults;

  int m_nProgress;
  // Random generator
  long randx;
  double z;
};

#endif // !defined(AFX_IEEE1180TEST_H__894E2496_042A_464F_826F_5E579A46138B__INCLUDED_)
