/* 
 *  StatsStrings.cpp
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#include <string.h>
#include "../RunState.h"
#include "../Language.h"
#include "../Video/misc_tables.h"
#include "StatsStrings.h"


extern TRunState rs;


char *MPEGframeRateStrings[16]={
				"Unexpected",
				"FILM 23.976 fps", 
				"FILM 24 fps",   
				"PAL 25 fps",
			  "NTSC 29.97 fps",
				"NTSC 30 fps",     
				"PAL 50 fps",    
				"NTSC 59.94 fps",
				"NTSC 60 fps",
				"","","","","","",""
};

char *MPEG2aspectStrings[16]=
				{"Unexpected", "1.0", "4:3","16:9",
			    "2.21:1","","","",
				"","","","",
				"","","",""};

char *MPEG1aspectStrings[16]=
				{ "Unexpected"      , "1.0",    "SAR 0.6735",     "16:9 PAL",
			      "SAR 0.7615"      , "SAR 0.8055",           "16:9 NTSC",      "SAR 0.8935",
				  "4:3 CCIR601 PAL" , "SAR 0.9815",           "1.0255",         "1.0695",
				  "4:3 CCIR601 NTSC", "",                     "",               ""};

int RenderStatsStrings( TStatsStrings *stats )
{
   char szTemp[1024];

    if(!stats)
        return 0;

    if(!rs.video)
        return 0;

    TMPGVideoInfo *MPGinf;
    TAudioInfo    *Audinf;

    MPGinf = rs.video->GetVideoInfo();
    if(!MPGinf)
        return 0;
    if(!rs.audio)
        Audinf = NULL;
    else
        Audinf = rs.audio->GetAudioInfo();

// Render InMedia
    sprintf(stats->InMedia.video_width,  "%d %s", MPGinf->width, GS(LANG_STATS_PIXELS) );
    sprintf(stats->InMedia.video_height, "%d %s", MPGinf->height, GS(LANG_STATS_PIXELS) );
    sprintf(stats->InMedia.video_size,   "%d x %d %s", MPGinf->width, MPGinf->height, GS(LANG_STATS_PIXELS) );
    //Aspect ratio
	if(MPGinf->isMPEG2)
		strcpy(stats->InMedia.video_aspect_ratio_information,
               MPEG2aspectStrings[MPGinf->aspect_ratio_information]);
	else
		strcpy(stats->InMedia.video_aspect_ratio_information,
               MPEG1aspectStrings[MPGinf->aspect_ratio_information]);
    //Bitrate
    sprintf(stats->InMedia.video_bit_rate, "%d bps",MPGinf->bit_rate_value*50*8);
    //Detected Frame Rate
    strcpy(stats->InMedia.video_detected_frame_rate, 
           MPEGframeRateStrings[MPGinf->detected_frame_rate_code]);
    //Frame Rate
    strcpy(stats->InMedia.video_frame_rate, 
           MPEGframeRateStrings[MPGinf->frame_rate_code]);
    //Format
    if(MPGinf->isMPEG2)
        strcpy(stats->InMedia.video_format,  "MPEG 2");
    else
        strcpy(stats->InMedia.video_format,  "MPEG 1");

    //Progressive
	if(MPGinf->progressive_frame)
		strcpy(stats->InMedia.video_structure, GS(LANG_STATS_PROGRESSIVE) );
	else
		strcpy(stats->InMedia.video_structure, GS(LANG_STATS_INTERLACED) );


    //Audio
	if (Audinf) {
		sprintf( stats->InMedia.audio_sample_freq, "%d Hz", Audinf->sample_rate );
    if(Audinf->format == AC3_FORMAT)
    {
      Audinf->subwoofer = Audinf->subwoofer ? 1 : 0;
		  sprintf( stats->InMedia.audio_channels, "%d.%d channels", Audinf->channels, Audinf->subwoofer );
    }
    else
    {
      sprintf( stats->InMedia.audio_channels, "%d channels", Audinf->channels);
    }

		sprintf( stats->InMedia.audio_bit_rate, "%d Kbps", Audinf->bit_rate );
		sprintf( stats->InMedia.audio_format, "%s", (Audinf->format == AC3_FORMAT)? "Dolby Digital" : "MPEG audio" );
	}
	else {
		sprintf( stats->InMedia.audio_sample_freq, "N/A");
		sprintf( stats->InMedia.audio_channels, "N/A");
		sprintf( stats->InMedia.audio_bit_rate, "N/A");
		sprintf( stats->InMedia.audio_format, "N/A");
	}

  // OUTPUTS
  sprintf( stats->OutMedia.video_format, "N/A" );

  sprintf(stats->OutMedia.video_width,  "%d %s", PPOST_WIDTH(rs.pp) , GS(LANG_STATS_PIXELS) );
  sprintf(stats->OutMedia.video_height, "%d %s", PPOST_HEIGHT(rs.pp) , GS(LANG_STATS_PIXELS) );
  sprintf(stats->OutMedia.video_size,   "%d x %d %s", PPOST_WIDTH(rs.pp), PPOST_HEIGHT(rs.pp), GS(LANG_STATS_PIXELS) );
  
	sprintf( stats->OutMedia.audio_sample_freq, "%d Hz", rs.prof.outSampleFrequency );
  sprintf( stats->OutMedia.audio_channels, "%d channels (Stereo)", 2 );
  sprintf( stats->OutMedia.audio_bit_rate, "N/A" );
  sprintf( stats->OutMedia.audio_format, "%s", "N/A" );

  float frame_rate = (float)rs.prof.timeBase.scale / (float)rs.prof.timeBase.sampleSize;
  if(rs.prof.timeBase.scale==23976)
    strcpy( szTemp, "23.976" );
  else
    sprintf( szTemp, "%0.2f", frame_rate );
  sprintf( stats->OutMedia.video_frame_rate, "%s fps", szTemp );
  return 1;
}
