/* 
 *  IEEE1180TestDlg.h
 *
 *	Copyright (C) Alberto Vigata - July 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#if !defined IEEE1180DLG_H
#define      IEEE1180DLG_H

#include "ieee1180test.h"
#include "..\Thread.h"

LRESULT CALLBACK DlgProcHook(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

class CIEEE1180Dlg: public CFlThread
{
public:
  CIEEE1180Dlg(HWND hParentWnd, HINSTANCE hInst);
  
  ~CIEEE1180Dlg(){};
  // Opens the dialog and performs the test
  bool IsIEEE1180( void (* TestIdct)(DCTELEM *block), char *pIdctId );
private:
  friend LRESULT CALLBACK DlgProcHook(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

  LRESULT CALLBACK DlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
  // Actual running thread
  DWORD ThreadProc();

  // 
  bool m_bIsIEEE1180;
  char *m_pIdctId;
  string strFinal;
  bool m_bFinished;

  int  m_nTestTime;
  // The actual testing object
  CIEEE1180Test m_obTester;
  HWND m_hParentWnd;
  HINSTANCE m_hInst;
  void (* m_pTestIdct)(DCTELEM *block);
};


#endif 