/* 
 *  IEEE1180TestDlg.cpp 
 *
 *	Copyright (C) Alberto Vigata - July 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include <windows.h>
#include "IEEE1180TestDlg.h"
#include "..\resource.h"
#include "..\auxiliary.h"
#include <CommCtrl.h> 

static CIEEE1180Dlg *gDlg;

static LRESULT CALLBACK DlgProcHook(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
  return gDlg->DlgProc(hWnd, message, wParam, lParam);
}

CIEEE1180Dlg::CIEEE1180Dlg( HWND hParentWnd, HINSTANCE hInst)
{ 
  m_hParentWnd = hParentWnd; m_hInst = hInst;
  gDlg = this;
}
 
bool CIEEE1180Dlg::IsIEEE1180(void (* TestIdct)(DCTELEM *block) , char *pIdctId)
{
  if(!TestIdct)
    return false;
  m_pTestIdct = TestIdct;
  m_pIdctId   = pIdctId;
  m_bFinished = false;
  return DialogBox(m_hInst, (LPCTSTR)IDD_IEEE1180DLG, m_hParentWnd, (DLGPROC)DlgProcHook)>0;
}

LRESULT CALLBACK CIEEE1180Dlg::DlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
  int nTimer;
  switch (message)
  {
		case WM_INITDIALOG:
      // Disable the ok button
      EnableWindow( GetDlgItem(hWnd, IDOK), false );
      // Set the status text
      strFinal = string("FlasKMPEG is analizing ") + m_pIdctId;

      // Create the thread
      Create();

      // Create timer
      nTimer = SetTimer(hWnd, 1, 20, NULL );      
      return TRUE;

    case WM_TIMER:
      SendDlgItemMessage(hWnd, IDC_PROGRESS, PBM_SETPOS, (WPARAM)m_obTester.GetProgress(), 0);
      strFinal += " .";
      SetDlgItemText( hWnd, IDC_EDIT, strFinal.c_str());
      if(m_bFinished)
      {
          strFinal.erase();
          strFinal = string("FlasKMPEG Analysis result: \r\n") + m_pIdctId;
          strFinal += m_bIsIEEE1180 ? " Meets IEEE1180 spec" : " Does NOT meet IEEE1180 spec \r\n";
          char tempStr[256];
          sprintf(tempStr, "\r\nTest time: %0.3f seconds\r\n", (float)m_nTestTime/1000.0 );
          strFinal += tempStr;

          strFinal += "\r\n\r\nAnalysis details:\r\n";
          strFinal += m_obTester.GetResults();

          EnableWindow( GetDlgItem(hWnd, IDOK), true );

          SetDlgItemText( hWnd, IDC_EDIT, strFinal.c_str() );
          KillTimer( hWnd, 1);
      }

      break;
    case WM_COMMAND:
      if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
      {
        // Close timer
        // Close thread first
        Close();
        EndDialog(hWnd, LOWORD(wParam));
        return TRUE;
      }
      break;
  }
  return FALSE;
}

DWORD CIEEE1180Dlg::ThreadProc()
{
  // Thread routine.
  m_nTestTime = GetTickCount();
  m_bIsIEEE1180 = m_obTester.IsIEEE1180( m_pTestIdct );
  m_nTestTime = GetTickCount() - m_nTestTime;
  m_bFinished = true;
  return FALSE;
}