/* 
 *  Graph.cpp 
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#include "..\flaskmpeg.h"
#include "..\auxiliary.h"
#include "..\resource.h"
#include "graph.h"

extern TConfig   o ;
extern i64 myClock;

void GraphStart(TGraph *gr){
	gr->posw       = 0;
	gr->last55[55];
	gr->br_actual  = 0;
	gr->br_max     = 0;
	gr->br_min     = 2000000000;
	gr->br_fr      = 0;
	gr->posw_input = 0;
	gr->br_avr     = 0;
}

void DrawGraph(HWND hDlg, TGraph *gr){
	//Agrabber start
			DlgSetText(hDlg, IDC_BR_A,   (gr->br_actual*5*25*8)/1024.0);
			DlgSetText(hDlg, IDC_BR_MAX, (gr->br_max*5*25*8)/1024.0);
			DlgSetText(hDlg, IDC_BR_MIN, (gr->br_min*5*25*8)/1024.0);
			if(myClock)
				DlgSetText(hDlg, IDC_BR_AVR, ((gr->br_avr*5*8)/1024.0)/((float)myClock/(float)27000000));
			
			if(o.options.displayVideo)
			{
				HDC hDC;
				HWND m_hwnd = GetDlgItem (hDlg, IDC_BITRATEHIST);
				hDC = GetWindowDC (m_hwnd);

				PatBlt(hDC,0,0,545,61,BLACKNESS);
				HPEN Fpen, oldpen;
				Fpen = CreatePen(PS_SOLID, 1, RGB(0,160,0));
				oldpen = (HPEN)SelectObject(hDC, Fpen);
 				for (int i=0;i<54;i++)
				{
					MoveToEx(hDC,i*10,0,NULL);
					LineTo(hDC,i*10,60);
				}
				for (i=0;i<7;i++)
				{
					MoveToEx(hDC,0,i*10,NULL);
					LineTo(hDC,544,i*10);
				}
				Fpen = (HPEN)SelectObject(hDC, oldpen);
				DeleteObject(Fpen);

				Fpen = CreatePen(PS_SOLID, 1, RGB(255,255,0));
				oldpen = (HPEN)SelectObject(hDC, Fpen);
				for (i=1;i<55;i++)
				{
					int y1,y2,x1,x2;
					x1 = i*10-10;
					x2 = i*10;
					y1 = gr->last55[i-1];
					y2 = gr->last55[i];
					MoveToEx(hDC,x1,y1,NULL);
					LineTo(hDC,x2,y2);

				}
				Fpen = (HPEN)SelectObject(hDC, oldpen);
				DeleteObject(Fpen);

/*				Fpen = CreatePen(PS_SOLID, 1, RGB(0,255,0));
				oldpen = (HPEN)SelectObject(hDC, Fpen);
				for (i=1;i<55;i++)
				{
					int y1,y2,x1,x2;
					x1 = i*10-10;
					x2 = i*10;
					y1 = last55_input[i-1];
					y2 = last55_input[i];
					MoveToEx(hDC,x1,y1,NULL);
					LineTo(hDC,x2,y2);

				}
				Fpen = (HPEN)SelectObject(hDC, oldpen);
				DeleteObject(Fpen);*/

//				SetPixel(hDC,posw*10,60-(bytesw/250),RGB(255,255,0));
			    ReleaseDC (m_hwnd, hDC);
			}
//Agrabber end	
}

void UpdateGraph(TGraph *gr, TAVIPlugGraphInfo *info){
	int i;
	int frame_size;
	frame_size = info->Video;

	gr->br_actual = (frame_size*8*25)/1000;
	gr->br_avr = gr->br_avr+gr->br_actual;
	gr->br_fr++;
	if (gr->br_actual>gr->br_max)
		gr->br_max = gr->br_actual;
	if (gr->br_actual<gr->br_min)
		gr->br_min = gr->br_actual;

	gr->last55[gr->posw]=60-( (frame_size/250)>=60 ? 0:(frame_size/250));
	if (gr->posw<54)
		gr->posw++;
	else
		for (i=1;i<55;i++)
			gr->last55[i-1]=gr->last55[i];
}