/* 
 *  language.h
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#if !defined(AFX_LANGUAGE_H__205B0701_EB94_11D3_816D_00000100CF13__INCLUDED_)
#define AFX_LANGUAGE_H__205B0701_EB94_11D3_816D_00000100CF13__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <stdio.h>
#define MAX_LANGUAGES 32
#define MAX_STRINGS   4096
#define GS(x) ( strcmp(rs.lng->GetString(x),"") ? rs.lng->GetString(x) : NULL )
///////////////////////////////////////////////////////////////////////
//   LANGUAGE DEFAULTS
///////////////////////////////////////////////////////////////////////

#define APPTITLE        3
#define MENU_FILE       100
	#define MENU_OPEN              101
	#define MENU_OPENDVDFILE       103
	#define MENU_EXIT              102

#define MENU_PROFILES   130

#define MENU_OPTIONS	110
	#define MENU_OUTPUTFORMAT       111
	#define MENU_OUTOPTIONS         112
	#define MENU_SELECTOUT          113
    #define MENU_LANGUAGE           114

#define MENU_RUN  120
	#define MENU_PLAYER       121
	#define MENU_STARTCONV    122


#define MENU_ABOUT		123
// OPTIONS
#define OPT_OK           200
#define OPT_CANCEL       201
#define OPT_SHOWPAD      202
#define OPT_SHOWPAD_EXP  199
#define OPT_TITLE        203
#define OPT_VIDEO        204
#define OPT_AUDIO        205
#define OPT_PPOST        206
#define OPT_FILES        207
#define OPT_GENERAL      208

#define OPT_FRAMESIZE      209
#define OPT_WIDTH          210
#define OPT_HEIGHT         211
#define OPT_FRAMESIZE_EXP  212
#define OPT_OUTPAD_EXP     213

#define OPT_TIMEBASE       214
#define OPT_TIMEBASE_EXP   215

#define OPT_IDCT_TITLE     216
#define OPT_IDCT_EXP       217
#define OPT_IDCT_MMX       218
#define OPT_IDCT_NONMMX    219
#define OPT_IDCT_REF       220

#define OPT_VIDEO_NOTE     221

//AUDIO
#define OPT_AUDIO_AUDIOMODE_EXP 240
#define OPT_AUDIO_AUDIOMODE     241
#define OPT_AUDIO_DSC           242
#define OPT_AUDIO_DOAUDIO       243
#define OPT_AUDIO_NOAUDIO       244
#define OPT_AUDIO_DSC_EXP       245
#define OPT_AUDIO_DOAUDIO_EXP   246
#define OPT_AUDIO_NOAUDIO_EXP   247
#define OPT_AUDIO_SAMPLING_EXP  248

#define OPT_AUDIO_SAMPLING_TITLE 250
#define OPT_AUDIO_SAMPLING_SAMEASINPUT 251
#define OPT_AUDIO_SAMPLING_SAMEASINPUT_EXP 252
#define OPT_AUDIO_TAB 253

// OUTPUT PAD
#define OUTPUT_PAD_TITLE        300
#define OUTPUT_PAD_HIDE         301
#define OUTPUT_PAD_OUTPUTSIZE   302
#define OUTPUT_PAD_RESET        303
#define OUTPUT_PAD_CROP         304
#define OUTPUT_PAD_LETTERBOX    305

// ABOUT
#define ABOUT_TITLE				310

// GENERAL STRINGS
#define WARN_OVERWRITE          400
#define WARNING                 401
  // FILE STREAM SELECTOR
#define FST_TITLE               402
#define FST_LATERAL             403
#define FST_BUTTON              404
#define FST_VIDEOFOUND          405
#define FST_AUDIOFOUND          406
#define FST_AUDIOTRACK          407
#define FST_MAINTRACK           408
#define FST_VIDEOTRACK          409


   // ERRORs
#define SIZE_OOR					410
#define SIZE_NOT16					411
#define	TIME_IS_NOT_POSITIVE		412
#define	TC_LARGER_THAN_HEIGHT		413
#define	BC_LARGER_THAN_HEIGHT		414
#define INCORRECT_SETTING           415
#define UNS_FILE_OPEN               416
#define NO_VIDEO_TRACK              417
#define ERROR_PLUGIN                418
#define IFO_PARSING_ERROR           419
#define ERROR_COMPILE               450

  // DVD STREAM SELECTOR
#define DVS_TITLE               420
#define DVS_LATERAL             421
#define DVS_BUTTON              422
#define DVS_PGCSFOUND           423
#define DVS_AUDIOFOUND          424
#define DVS_DURATION            425
#define DVS_SUBPICFOUND         426
#define DVS_ANGLE               427

   // STATS
#define LANG_STATS_PIXELS       500
#define LANG_STATS_PROGRESSIVE  501
#define LANG_STATS_INTERLACED   502


#ifdef LANGUAGE_MODULE
	char *ds[MAX_STRINGS];

	void LoadDefaultStrings()
	{
		int i;
		for(i=0; i<MAX_STRINGS; i++)
			ds[i]=NULL;

		ds[APPTITLE]                 = "FlasKMPEG";
		ds[MENU_FILE]                = "&File";
			ds[MENU_OPEN]            = "&Open Media";
			ds[MENU_OPENDVDFILE]     = "Open &DVD File";
			ds[MENU_EXIT]            = "&Exit";
		ds[MENU_OPTIONS]             = "&Options";
			ds[MENU_OUTPUTFORMAT]    = "&Output Format Options";
			ds[MENU_OUTOPTIONS]      = "&Global Project Options (Export Movie Settings)";
			ds[MENU_SELECTOUT]       = "&Select Output Format";
		ds[MENU_RUN]                 = "&Run";
			ds[MENU_PLAYER]          = "&Player";
			ds[MENU_STARTCONV]       = "&Start Conversion";
		ds[MENU_ABOUT]               = "&About";

		ds[WARN_OVERWRITE]           = "An output file is going to be overwritten. Should I continue?";
		ds[WARNING]                  = "FlasKMPEG Warning";

		ds[FST_TITLE]                = "FlasKMPEG Stream Selector";
		ds[FST_LATERAL]              = "One or more audio or video tracks were found in the input file. Select the desired ones";
		ds[FST_BUTTON]                = "FlasK it!";
		ds[FST_VIDEOFOUND]                = "Video Streams found";
		ds[FST_AUDIOFOUND]                = "Audio Streams found";
		ds[FST_AUDIOTRACK]                = "audio track";
		ds[FST_MAINTRACK]                 = "inside main track";
		ds[FST_VIDEOTRACK]                = "video track";

		ds[DVS_TITLE]                = "FlasKMPEG DVD Selector";
		ds[DVS_LATERAL]              = "Select DVD titles, audio tracks and subtitles.\n\n If you don't want subtitles, deselect all of them";
		ds[DVS_BUTTON]                = "FlasK this DVD!";
		ds[DVS_PGCSFOUND]                = "DVD titles";
		ds[DVS_AUDIOFOUND]                = "DVD Audio tracks";
		ds[DVS_DURATION]                = "Duration";
		ds[DVS_SUBPICFOUND]             = "DVD subtitles";
		ds[DVS_ANGLE]                = "angle";

ds[SIZE_OOR]				= "Size is out of range. Try another value",
ds[SIZE_NOT16]				= "The number is not divisible by 16",
ds[TIME_IS_NOT_POSITIVE]	= "The Time you entered is invalid",
ds[TC_LARGER_THAN_HEIGHT]	= "Top crop is larger than image height",
ds[BC_LARGER_THAN_HEIGHT]	= "Bottop crop is larger than image height",
ds[INCORRECT_SETTING]		= "This setting is invalid. Read the docs for correct settings",
ds[UNS_FILE_OPEN]			= "An error ocurred when opening the file",
ds[NO_VIDEO_TRACK]			= "No video track was found in the input file. At least one video track is mandatory.";
ds[ERROR_PLUGIN]            = "There was a problem loading the plugins.\nNo output plugins were found. Please, check the installation\n and read the manual\n\n   Program will exit";
ds[IFO_PARSING_ERROR]        = "There was a problem while parsing the IFO file. \nRead the documentation for its posible causes.";
ds[ERROR_COMPILE]            = "An error ocurred when trying to generate the file.\n Check that you're not using the output file or the program is\n setup correctly.";



// Stats

ds[LANG_STATS_PIXELS]       = "Pixels";
ds[LANG_STATS_PROGRESSIVE]  = "Progressive";
ds[LANG_STATS_INTERLACED]   = "Interlaced";

		
	}
#endif

class CLanguage  
{
public:
	int ReadLanguage(int language);
	char * GetString(int str_id);
	int SetLanguage( int n_lang );
	int GetLanguage();
	char * GetLanguageID();
	int GetNumberLang();
	int Start();
	CLanguage(char *program_directory);
	virtual ~CLanguage();

private:
    char program_directory[MAX_PATH];
	int  selected_language;
	int  n_lang;
	int GetStrings( FILE *file);
};

#endif // !defined(AFX_LANGUAGE_H__205B0701_EB94_11D3_816D_00000100CF13__INCLUDED_)
