/* 
 *  language.cpp 
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#include <windows.h>
#include <winbase.h>

#define LANGUAGE_MODULE
#include "Language.h"
#undef  LANGUAGE_MODULE

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
static char filenames[MAX_LANGUAGES][1024];
static char * strings[MAX_LANGUAGES][MAX_STRINGS];
static int    strings_alloc[MAX_LANGUAGES][MAX_STRINGS];


CLanguage::CLanguage(char *program_directory)
{
	selected_language=0;
    if(program_directory)
        strcpy(this->program_directory, program_directory);
}

CLanguage::~CLanguage()
{
	int i,j;
	//Deallocate strings
	for(i=0; i<MAX_LANGUAGES; i++)
		for(j=0; j<MAX_STRINGS; j++){			      
			if(strings_alloc[i][j] == 1)
				free(strings[i][j]);
		}

}

int CLanguage::Start()

{
	WIN32_FIND_DATA find_data;
	char     directory[MAX_PATH];
	HANDLE   search_handle;
	int      no_lang_package_flag;
	int i,j;

    sprintf(directory, "%s\\Lang\\*.lang.flask", program_directory);
	i=0;
	search_handle = FindFirstFile(directory, &find_data);
	if(search_handle==INVALID_HANDLE_VALUE){
		n_lang=0;
	}
	else{
		strcpy( filenames[i++], find_data.cFileName );
		while( FindNextFile(search_handle, &find_data ) ){
			strcpy( filenames[i++], find_data.cFileName );
		}
		FindClose(search_handle);
		n_lang = i;
	}
	if(n_lang==0)
		n_lang=1;

	no_lang_package_flag = !n_lang;

	//initialize string pointers
	for(i=0; i<MAX_LANGUAGES; i++)
		for(j=0; j<MAX_STRINGS; j++){
			      strings[i][j] = NULL;
			strings_alloc[i][j] = 0;
		}



	LoadDefaultStrings();
	// load default strings in all language sets
	for(i=0; i<n_lang; i++)
		for(j=0; j<MAX_STRINGS; j++)
			strings[i][j] = ds[j] ? ds[j]:NULL;

	//Load strings from files
	if(!no_lang_package_flag){
		for(i=0;i<n_lang;i++)
			ReadLanguage(i);
	}
	selected_language=0;
	return 0;
}

int CLanguage::GetNumberLang()
{
	return n_lang;
}

char * CLanguage::GetLanguageID()
{
	char *ID;
	ID=strings[selected_language][0];
	if(ID)
		return ID;
	else
		return "unknown";
}
int CLanguage::GetLanguage()
{
	return selected_language;
}

int CLanguage::SetLanguage(int n_lang)
{
	if(n_lang >= this->n_lang)
		return 0;
	selected_language = n_lang;
	return 1;
}

char * CLanguage::GetString(int str_id)
{
	if(str_id>MAX_STRINGS)
		return "";

	return strings[selected_language][str_id]?strings[selected_language][str_id]:"";
}

int CLanguage::GetStrings(FILE *file)
{
	return 0;
}

int CLanguage::ReadLanguage(int language)
{
	FILE *f=NULL;
	char  token=0;
	int   str_num, string_chars;
	char  full_name[MAX_PATH];

    sprintf(full_name, "%s\\Lang\\%s", program_directory, filenames[language]);
	//open file
	f=fopen(full_name, "rb");
	if(!f)
		return 0;

	while(!feof(f)){
		//Search for token #
		while(token!='#' && !feof(f))
			fread(&token, 1, 1, f);
		//get number after token
		if(!feof(f)){
			fscanf(f, "%d", &str_num);
			if(str_num>MAX_STRINGS)
				continue;
		}

		//Search for token $
		while(token!='#' && !feof(f))
			fread(&token, 1, 1, f);
		while(token!='"' && !feof(f))
			fread(&token, 1, 1, f);

		//Read every single byte of the string
		if(!feof(f)){
			fread(&token, 1, 1, f);
			string_chars = 0;

			strings[language][str_num]=NULL;
			while(token!='"' && !feof(f)){
				string_chars++;
				strings[language][str_num]=(char *)realloc(strings[language][str_num], string_chars);
				strings[language][str_num][string_chars - 1] = token;
				strings_alloc[language][str_num] = 1;
				fread(&token, 1, 1, f);
			}
			//NULL terminate the string
			string_chars++;
			strings[language][str_num]=(char *)realloc(strings[language][str_num], string_chars);
			strings[language][str_num][string_chars - 1] = 0;

		}


	}

	
	fclose(f);
	return 1;
}
