/* 
 *  FlasKMPEG.h 
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#ifndef FLASKMPEG_H
#define FLASKMPEG_H

#include <windows.h>
#include <winbase.h>
#include <wingdi.h>
#include <CommCtrl.h> 
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>


//Premiere Includes
#include ".\Premiere\prTypes.h"
#include ".\Premiere\prCompile.h"
#include ".\Premiere\prWinEnv.h"
#include  ".\Premiere\premiere.h"


#include "./FlasKTypes.h"
#include "./Audio/Audio.h"

#include <io.h>

#define MAXFILENAME 1024
#define VERSION 6000 
#define FLASK_VERSION VERSION
#define PROFILE_VERSION 1000

struct TProfile
{
  int         nProfileVersion;
  char profile_name[MAXFILENAME];

  bool                compileWhole;
	int					displayTimeUnits; /* general diag box: 0 = seconds, 1 = frames */
	unsigned long		framesToCompile;
	int					selectedTab;

   	bool                warn_overwrite;
	bool                shutdown;
	int					lurk_size;
	//Video options
	int					InterpolatedWidth;
	int					InterpolatedHeight;
	compTimebaseRec		timeBase;
	bool                recons_progressive;

	//Crop and letterboxing
	bool				crop;
	int					cropTopOffset;
	int					cropHeight;
	int					cropLeftOffset;
	int					cropWidth;

	bool				letterbox;
	int					letterboxTop;
	int					letterboxBottom;
	int					letterboxLeft;
	int					letterboxRight;

	//Interlacing
	int					deinterlace;
	int					threshold;
	int					blend;

	bool				keepAspect;
	bool			  idctAutoSelect;
  int         idctIndex;


	//Audio options
	int				audioMode; 
	int					  outSampleFrequency;
	bool				  sampleFreqSameAsInput;
  TAudioProperties sAudioProperties;

    //Interpolation filter options
	int					filter;

	//File options
	char				inputFile[MAXFILENAME];
	char					inputDir[MAXFILENAME];
	char                outputFile[MAXFILENAME];
	char					outputDir[MAXFILENAME];
	char                audioOutFile[MAXFILENAME];
	char					audioOutDir[MAXFILENAME];



} ;

/* FlasK MPEG options */
typedef struct
{
  //Miscelaneous
  bool				firstTimeRunning;
  bool        showDetailsInProgress;
  
  int					outputFormat;
  int         hOutputFile;
  int					priority;
  int         selected_language;
  int         selected_profile;
  
  bool				displayVideo;
  ui32    		presentFrame;

  // Last opened files
	char		      lastFiles[4][MAXFILENAME];
} TagOptions;

typedef struct
{
	int			version;
	TagOptions  options;
} TConfig; //Run State configuration structs

//audioTypes
#define AC3			0
#define MPEG		1
#define NO			2


typedef struct
{
	ULONG        totalFileSize;
	ULONG		currentPosition;
} TFileProgress;


int LoadRegistryConfig( TConfig *Config );
void SaveRegistryConfig( TConfig *Config );
void ShowInConsole(char *buffer);



#define  MAX_IMAGE_MEM 1024*1024*4

#define INPUT_NOEXIST			1
#define IS_TRANSPORTSTREAM      2
#define NOT_RECOGNIZED			3
#define NO_AUDIOVIDEO           4





#endif 