/* 
 *  FlasKMPEG.cpp 
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */




#include "FlasKMPEG.h"

#include "./Demux/Demux.h"
#include "./Video/VideoWrapper.h"
#include "./Audio/Audio.h"
#include "./plugins.h"
#include "./error.h"
#include "./RunState.h"
#include "./language.h"
#include "./Misc/Graph.h"
#include "./Misc/StatsStrings.h"
#include "./FileOpen.h"
#include "./AudioProperties.h"
#include "./Audio/ExportAudio.h"
#include "./Player.h"
#include "./AudioPlayer.h"
#include "./ProgressDlg.h"
#include "./Mism.h"


#include "YUVtoRGB.h"
#include <malloc.h>
#include <commdlg.h>
#include <CommCtrl.h> 
#include "resource.h"
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <fcntl.h>
#include <math.h>
#include <mbstring.h>

#include ".\Resizer\filter.h"
#include ".\Resizer\resizer.h"
#include ".\postprocessing.h"
#include ".\windebug.h"
#include "auxiliary.h"
#include "mmx.h"

#define MAX_LOADSTRING 100
#define TESTING_IFO_PARSER
//#define TESTING_AUDIO_OUTPUT
//#define TESTING_MULTIAUDIO
// Global Variables:
extern "C" BOOL FPU_enabled;

BOOL FPU_enabled;
HINSTANCE		    hInst;								// current instance
TCHAR				szTitle[MAX_LOADSTRING];								// The title bar text
TCHAR				szWindowClass[MAX_LOADSTRING];								// The title bar text
HANDLE				hThrd;
DWORD					IDThread, ENCIDThread; 
HANDLE				hEncodingThread;



unsigned char       *newblock;
char                program_directory[MAX_PATH];


TRunState rs;

VBitmap				Display;
VBitmap				DecodedImage;

CFrame frBackground(NULL);

HWND  				hMainWnd;
BITMAPINFOHEADER	DibHeader;
BITMAPINFO			DibInfo;
BOOL                playerStopped;
BOOL				 abortCompile;		//Use this to abort the compile
BOOL				 audioFinished;
BOOL				compileAborted;     //Use this to kill progress dialog
BOOL				decodingFinished;	//The decoding thread has finished
//framerate sync variables
i64 myClock;
static i64 frameSpan;
static double audioSamplesPerFrame;

bool   imageWaiting;
bool   firstTime;
bool   firstImageAlreadyDecoded=false;
presInfo pInfo;
// Compiling globals
int		audioPrevFrame;
bool    pauseCompile;
bool	compileIsPaused;

TFileProgress		FileProgress;



typedef enum{LOAD_LIBRARY,
	 ENCODE,
	UNLOAD_LIBRARY}		EncEnum;
EncEnum		sendEncodingThread;

unsigned char       DisplayImage[MAX_IMAGE_MEM];
unsigned char		MPEGImage[MAX_IMAGE_MEM];



// 
#ifdef TESTING_AUDIO_OUTPUT
	FILE	*test_sound_file;
#endif
//  Output Options
TConfig o;
// Premiere Related Globals
// For private settings of plugin
compDoCompileInfo       CompileInfo;	                //For Compiling...



// Foward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK    OutputOptionsDlg(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK	ProgressDlg(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);

               void SetTextMenu();


int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
 	// TODO: Place code here.
	MSG msg;
	HACCEL hAccelTable;

  // Create Basic FlasKMPEG objects
  char szTemp[MAX_PATH];
  GetModuleFileName(NULL, szTemp, MAX_PATH);
  // Copy just the path
  _mbsnbcpy( (unsigned char *)program_directory, (unsigned char *)szTemp, strlen(szTemp) - strlen("FlasKMPEG.exe") -1 );

  rs.lng = new CLanguage(program_directory);
  if(rs.lng){
    rs.lng->Start();
  }

    rs.profiler = new CProfile(program_directory);

	// Initialize global strings
	strcpy( szTitle, GS(APPTITLE) );
  //	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_FLASKMPG2MPG1, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_FLASKMPG2MPG1);

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return msg.wParam;
}


//   BITMAP DISPLAY INIT
void InitDibDisplay(int oxsize, int oysize)
{
  RECT wr,cr;
  int  d;
  
  memcpy(&DibInfo.bmiHeader, &DibHeader, sizeof(BITMAPINFOHEADER));
  // Set Window Size
  
  // size window to film size
  SetRect(&cr,0,0,oxsize, oysize);
  wr=cr;
  AdjustWindowRect(&wr,GetWindowLong(hMainWnd,GWL_STYLE),TRUE);
  OffsetRect(&wr,-wr.left,-wr.top);
  SetWindowPos(hMainWnd,HWND_TOP,0,0,wr.right,wr.bottom,SWP_NOMOVE);
  
  // for QSIF movies the menu will wrap around so we need
  // to increase the height of the window
  GetClientRect(hMainWnd, &wr);
  d=cr.bottom-(wr.bottom-wr.top);
  
  if (d>0)
  {
    GetWindowRect(hMainWnd, &wr);
    SetWindowPos(hMainWnd,HWND_TOP,0,0,wr.right-wr.left,wr.bottom-wr.top+d,SWP_NOMOVE);
  }
}



// file=> file to get extension from
// ext => string to put extension
char *get_file_ext(char *file, char *ext){
    if(!file || !ext)
        return NULL;
    int len = strlen( file );

    ext[0] = file[len-3];
    ext[1] = file[len-2];
    ext[2] = file[len-1];
    ext[3] = 0;
    return ext;
}

void SetWindowSize( void )
{
RECT cr,wr;
int d;
	        // size window to film size
		    SetRect(&cr,0,0,352, 288);
	        wr=cr;
	        AdjustWindowRect(&wr,GetWindowLong((HWND)hMainWnd,GWL_STYLE),TRUE);
	        OffsetRect(&wr,-wr.left,-wr.top);
			SetWindowPos((HWND)hMainWnd,HWND_TOP,0,0,wr.right,wr.bottom,SWP_NOMOVE);

	        // for QSIF movies the menu will wrap around so we need
	        // to increase the height of the window
	        GetClientRect((HWND)hMainWnd, &wr);
	        d=cr.bottom-(wr.bottom-wr.top);

	        if (d>0)
	        {
	          GetWindowRect((HWND)hMainWnd, &wr);
	          SetWindowPos((HWND)hMainWnd,HWND_TOP,0,0,wr.right-wr.left,wr.bottom-wr.top+d,SWP_NOMOVE);
	        }
}



//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    This function and its usage is only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
  WNDCLASSEX wcex;
  
  wcex.cbSize = sizeof(WNDCLASSEX); 
  
  wcex.style			= CS_HREDRAW | CS_VREDRAW;
  wcex.lpfnWndProc	= (WNDPROC)WndProc;
  wcex.cbClsExtra		= 0;
  wcex.cbWndExtra		= 0;
  wcex.hInstance		= hInstance;
  wcex.hIcon			= (HICON)LoadImage(hInstance, (LPCTSTR)IDI_FLASKMPG2MPG1, IMAGE_ICON, 0,0,0);
  wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
  wcex.hbrBackground	= 0/*(HBRUSH) GetStockObject(BLACK_BRUSH)*/;
  wcex.lpszMenuName	= (LPCSTR)IDC_FLASKMPG2MPG1;
  wcex.lpszClassName	= szWindowClass;
  wcex.hIconSm		= NULL;//LoadIcon(wcex.hInstance, (LPCTSTR)IDI_FLASKMPG2MPG1);
  
  return RegisterClassEx(&wcex);
}

//
//   FUNCTION: InitInstance(HANDLE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
// Mesage handler for about box.
LRESULT CALLBACK WelcomeDlg(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  int n_lang, i;
  switch (message)
  {
		case WM_INITDIALOG:
      //Language Selection
      DlgSetText(hDlg, R_WELCOME_LANG, GS(MENU_LANGUAGE));
      n_lang = rs.lng->GetNumberLang();
      for(i=0; i<n_lang; i++){
        rs.lng->SetLanguage(i);
        ListAddText(GetDlgItem(hDlg, R_LANG_LIST), rs.lng->GetLanguageID() );
        if(strcmp(rs.lng->GetLanguageID(), "English")==0)
        {
          o.options.selected_language = i;
          ListSetCur(GetDlgItem(hDlg, R_LANG_LIST), i);
        }

      }
      
      return TRUE;
      
    case WM_COMMAND:
      
      
      if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
      {
        EndDialog(hDlg, LOWORD(wParam));
        return TRUE;
      }
      if(HIWORD(wParam)==CBN_SELCHANGE){
        rs.lng->SetLanguage( SendDlgItemMessage(hDlg, R_LANG_LIST, CB_GETCURSEL, 0,0) );
        o.options.selected_language = rs.lng->GetLanguage();
        SetTextMenu();
        return TRUE;
      }
      break;
  }
  return FALSE;
}

// WorkOut how many last files there are
int LastFilesCount()
{
  int files=0;
  for( int i=0; i<4; i++ )
  {
    if( o.options.lastFiles[i][0]!='\0' )
      files++;
  }
  return files;
}


void InsertFileInLastFilesList( char *file )
{
  if(file)
  {
    for(int i=3; i>=1; i--)
    {
      strcpy( o.options.lastFiles[i], o.options.lastFiles[i-1] );
    }
    strcpy( o.options.lastFiles[0], file );
  }
}
// Rebuild the menu from all settings
void SetTextMenu(){
  HMENU menu;
  int i;

  MenuSetText(GetMenu(hMainWnd), 0, GS(MENU_FILE));
  MenuSetText(GetMenu(hMainWnd), 1, GS(MENU_PROFILES));
  MenuSetText(GetMenu(hMainWnd), 2, GS(MENU_OPTIONS));
  MenuSetText(GetMenu(hMainWnd), 3, GS(MENU_RUN));
  MenuSetText(GetMenu(hMainWnd), 4, GS(MENU_ABOUT));
  
  // File preferences
  menu = MenuGetPopup(GetMenu(hMainWnd), 0);
  MenuSetText( menu, 0, GS(MENU_OPEN));
    // LastFiles
    while(RemoveMenu(menu, 2, MF_BYPOSITION ));
    for(i=0; i<LastFilesCount(); i++)
    {
      MenuAddItem( menu, i+3, i+10500, o.options.lastFiles[i] );
    }
  MenuAddSeparator( menu, LastFilesCount() + 2 );
  MenuAddItem( menu, LastFilesCount() + 3, IDM_EXIT, GS(MENU_EXIT) );
  
  // Presets
  menu = MenuGetPopup(GetMenu(hMainWnd), 1);
  while(RemoveMenu(menu, 0, MF_BYPOSITION ));
  
  for(i=0; i<rs.profiler->GetCount(); i++){
    MenuAddItem( menu, i, i+10400, (rs.profiler->Get(i))->profile_name );
  }
  MenuCheck(hMainWnd, 10400+rs.profiler->GetSelectedIndex() );
  
  // Options preferences
  menu = MenuGetPopup(GetMenu(hMainWnd), 2);
  MenuSetText( menu, 0, GS(MENU_OUTPUTFORMAT));
  MenuSetText( menu, 1, GS(MENU_OUTOPTIONS));
  MenuSetText( menu, 3, GS(MENU_SELECTOUT));
  MenuSetText( menu, 5, GS(MENU_LANGUAGE));
  
  // Output plugins
  menu = MenuGetPopup(GetMenu(hMainWnd), 2);
  menu = MenuGetPopup(menu, 3);
  while(RemoveMenu(menu, 0, MF_BYPOSITION ));
  
  for(i=0; i<rs.plugs.OutPluginCount; i++){
    MenuAddItem( menu, i, i+10300, rs.plugs.outPlugs[i].ID );
  }
  MenuCheck(hMainWnd, 10300+rs.selected_out_plug);
  
  //Languages menus
		// Get languages popup
  menu = MenuGetPopup(GetMenu(hMainWnd), 2);
  menu = MenuGetPopup(menu, 5);
  
  while(RemoveMenu(menu, 0, MF_BYPOSITION ));
  
  
  int current_lang = rs.lng->GetLanguage();
  int n_lang = rs.lng->GetNumberLang();
  for(i=0; i<n_lang; i++){
    rs.lng->SetLanguage(i);
    MenuAddItem(menu, i, i+10000, rs.lng->GetLanguageID() );
  }
  
  rs.lng->SetLanguage(current_lang);
  
  //Run
  menu = MenuGetPopup(GetMenu(hMainWnd), 3);
  MenuSetText( menu, 0, GS(MENU_PLAYER));
  // TODO language stuff for extract wav and audioplayer
  MenuSetText( menu, 4, GS(MENU_STARTCONV));
  
  
  DrawMenuBar( hMainWnd );
}

void SetMenuMPEG(){
	MenuCheck(hMainWnd, IDM_MPEG);
	MenuUnCheck(hMainWnd, IDM_AVI);
	MenuEnable(hMainWnd,IDM_MPEG1OPTIONS);
}
void SetMenuAVI(){
	MenuCheck(hMainWnd, IDM_AVI);
	MenuUnCheck(hMainWnd, IDM_MPEG);
	//MenuDisable(hMainWnd,IDM_MPEG1OPTIONS);
	MenuEnable(hMainWnd,IDM_MPEG1OPTIONS);
}
void EnableMenu(){
	MenuEnable(hMainWnd, IDM_PLAY);
	MenuEnable(hMainWnd, IDM_AUDIOPLAY);
	MenuEnable(hMainWnd, IDM_MPEG1OPTIONS);
	MenuEnable(hMainWnd, IDM_EXTRACTAUDIO);

	MenuEnable(hMainWnd, IDM_START2);
	MenuEnable(hMainWnd, IDM_OUTPUTCONFIG);
	//EnableMenuItem(GetSubMenu(GetMenu(hMainWnd), 1), GetMenuItemID(GetSubMenu(GetMenu(hMainWnd), 1),3), MF_GRAYED);

}
void DisableMenu(){
	MenuDisable(hMainWnd, IDM_PLAY);
	MenuDisable(hMainWnd, IDM_AUDIOPLAY);
	MenuDisable(hMainWnd, IDM_EXTRACTAUDIO);
	MenuDisable(hMainWnd, IDM_MPEG1OPTIONS);
	MenuDisable(hMainWnd, IDM_START2);
	MenuDisable(hMainWnd, IDM_OUTPUTCONFIG);
//	MenuDisable(hMainWnd, IDM_DISPLAYVIDEO);
	MenuDisable(hMainWnd, IDM_MPEG);
	MenuDisable(hMainWnd, IDM_AVI);
}

// Disable/Enable AllMenu are called to 
// disable/enable menu options when compiling
void DisableAllMenu(){
	DisableMenu();
	MenuDisable(hMainWnd, IDM_OPENFILE);
    MenuDisable(hMainWnd, IDM_OPENDVD);
	MenuDisable(hMainWnd, IDM_EXIT);
    DragAcceptFiles(hMainWnd, FALSE);

}
void EnableAllMenu(){
	EnableMenu();
	MenuEnable(hMainWnd, IDM_OPENFILE);
    MenuEnable(hMainWnd, IDM_OPENDVD);
	MenuEnable(hMainWnd, IDM_EXIT);
    DragAcceptFiles(hMainWnd, TRUE);
}

void LoadDefaultProfile()
{
  rs.prof.idctAutoSelect = 1;
  rs.prof.idctIndex=  0;
	rs.prof.selectedTab=0;

	rs.prof.warn_overwrite=   true;
	rs.prof.shutdown      =   false;
	rs.prof.lurk_size     =   5000;

	rs.prof.crop			=	false;
	rs.prof.cropTopOffset =	0;
	rs.prof.cropHeight	=	288;
	rs.prof.cropLeftOffset=	0;
	rs.prof.cropWidth		=	352;


	rs.prof.letterbox		=	false;
	rs.prof.letterboxTop	=	0;
	rs.prof.letterboxBottom=	0;
	rs.prof.letterboxLeft	=	0;
	rs.prof.letterboxRight=	0;

	rs.prof.deinterlace   =   0;
	rs.prof.blend         =   1;
	rs.prof.threshold     =  20;

	rs.prof.keepAspect                     = true;
	rs.prof.recons_progressive             = true;

	rs.prof.InterpolatedWidth=352;
	rs.prof.InterpolatedHeight=288;
	rs.prof.compileWhole       = true;
	rs.prof.framesToCompile                = 3000;
	rs.prof.filter                         = FILTER_TABLEBICUBIC;

	rs.prof.timeBase.scale                 = 25;
	rs.prof.timeBase.sampleSize            = 1;
	rs.prof.timeBase.value                 = 0xFFFFFF;

  rs.prof.audioMode                      = DO_AUDIO;
	rs.prof.outSampleFrequency             = 44100;
	rs.prof.sampleFreqSameAsInput          = true;
  rs.prof.sAudioProperties.drc           = false;
  rs.prof.sAudioProperties.drc_value     = 3;
  rs.prof.sAudioProperties.multichannel_volume = false;
  rs.prof.sAudioProperties.center        = 0;
  rs.prof.sAudioProperties.rear          = 0;
  rs.prof.sAudioProperties.front         = 0;
  rs.prof.sAudioProperties.normalize     = false;
  rs.prof.sAudioProperties.normalize_value = 100;
  rs.prof.sAudioProperties.dolby_surround_downmix = true;


  strcpy(rs.prof.profile_name, "Default");
  strcpy(rs.prof.audioOutFile, "C:\\flaskAudioOut");
	strcpy(rs.prof.outputFile, "C:\\flaskOut");

    return;
}
void LoadFirstTime(HINSTANCE hInstance, HWND hWnd){

    LoadDefaultProfile();

	o.version=VERSION;
	o.options.showDetailsInProgress=true;

	o.options.priority      =   1;
	o.options.displayVideo                   = true;


	o.options.hOutputFile                    = NULL;
	o.options.presentFrame                   = 0;
	o.options.outputFormat                   = 0;

  // Try to select odml avi plugin as default
  for(int i=0; i<rs.plugs.OutPluginCount; i++)
    if(rs.plugs.outPlugs[i].fileType == ODMLtype)
    {
      o.options.outputFormat = i;
      break;
    }

  o.options.selected_profile               = 0;

	o.options.firstTimeRunning= true;

  // Set no files as default
  o.options.lastFiles[0][0] = '\0';
  o.options.lastFiles[1][0] = '\0';
  o.options.lastFiles[2][0] = '\0';
  o.options.lastFiles[3][0] = '\0';

	SaveRegistryConfig(&o);
	LoadRegistryConfig(&o);
	DialogBox(hInstance, MAKEINTRESOURCE(IDD_WELCOME), hWnd, (DLGPROC)WelcomeDlg);
}


BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   rs.hInst    = hInst    =  hInstance; // Store instance handle in our global variable
   rs.hMainWnd = hMainWnd =  hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPED|WS_SYSMENU|WS_MINIMIZEBOX ,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

   DragAcceptFiles(hWnd, TRUE);

    //Load plugins
	if(!LoadPlugins(&rs.plugs, program_directory)){
		PrintError(ERROR_PLUGIN, (int)hMainWnd, 0);
		exit(0);
	}



   	//Starting options
	if(LoadRegistryConfig(&o)==0)	//This is the first time. Load defaults
	{
		LoadFirstTime(hInstance, hWnd);
	}
	else
	{
		//Key existed. Check version
		if(o.version!=VERSION)
			LoadFirstTime(hInstance, hWnd);
		else
			o.options.firstTimeRunning=false;
	}

  // Loading Profiles
  if(!rs.profiler->Refresh() )
  {
    // Oops. No profiles were present
    LoadDefaultProfile();
    // Try to add the default profile
    rs.profiler->AddProfile( &rs.prof );
    if( !rs.profiler->Refresh() )
      return FALSE;
  }
  else
  {
    rs.profiler->Select( o.options.selected_profile );
    rs.prof = *rs.profiler->GetSelected();
  }
  // If the first time running, select the default profile
  if(o.options.firstTimeRunning)
  {
    rs.profiler->SelectDefault();
    rs.prof = *rs.profiler->GetSelected();
  }


  // Load Misms. Needs a profile to start with.
  if(!StartMism()){
    exit(0);
  }
	if(rs.plugs.OutPluginCount <= o.options.outputFormat)
		o.options.outputFormat = 0;

	rs.selected_out_plug = o.options.outputFormat;
    SetTextMenu();
	//Miscelaneous Inits
	SetWindowSize();
  // Move window
  WindowMove( hWnd, 20, 20);
	compileAborted=true;
	playerStopped=true;
	rs.startFilePos=0;
	rs.audio = NULL;
	rs.video = NULL;
  rs.hPlayerWnd = NULL;

  // Initialize video renderer
  rs.pVideoRenderer = new CVideoRenderer(hWnd);
  // Set the background logo
  HBITMAP hbm=        LoadBitmap( hInst, MAKEINTRESOURCE(IDB_FONDO));
  frBackground.GetFromBmp(hbm);
  // The frame makes its own copy of the bitmap, so you can close the
  // original now
  DeleteObject(hbm);
  // Set the bitmap as a background for the video renderer
  rs.pVideoRenderer->SetBackground(&frBackground);

	rs.lng->SetLanguage( o.options.selected_language );
	SetTextMenu();
	rs.working_mode      =  FILE_MODE;

  ShowWindow(hWnd, nCmdShow);

   UpdateWindow(hWnd);
	MMX_check();
	if(MMX_capable)
		MMX_enable(1);
   
   //hdd=DrawDibOpen();
   return TRUE;
}

//
//  FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;
	TCHAR szHello[MAX_LOADSTRING];
  HWND hDlg;

	LoadString(hInst, IDS_HELLO, szHello, MAX_LOADSTRING);


	switch (message) 
	{
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam);

			// HANDLING CUSTOM MENUES
      // LastFiles list
			if(wmId >= 10500 && wmId <=10503)
      {
        HidePlayer();
				if(OpenFile( o.options.lastFiles[wmId-10500] ))
        {
          // clear jobs
          rs.vBatchList.clear();
          ShowPlayer();
        }
      }

			// Language
			if(wmId >= 10000 && wmId <10256){
				rs.lng->SetLanguage(wmId-10000);
				SetTextMenu();
			}
			// Plugins
			if(wmId >= 10300 && wmId <(10300+MAX_OUT_PLUGINS) ){
				rs.selected_out_plug = wmId - 10300;
				SetTextMenu();
			}
      // Profiles
			if(wmId >= 10400 && wmId <10499 ){
				rs.profiler->Select( wmId - 10400 );
        rs.prof = *rs.profiler->GetSelected();
				SetTextMenu();
			}

			// Parse the menu selections:
			switch (wmId)
			{

				case IDM_OPENFILE:
          HidePlayer();
					if( OpenFile(NULL) )
          {
            // clear jobs
            rs.vBatchList.clear();
            InsertFileInLastFilesList( rs.openedFileName );
            SetTextMenu();
            ShowPlayer();            
          }
					break;
				case IDM_MPEG1OPTIONS:
          HidePlayer();
          rs.obOutputManager.ConfigureOutput(rs.selected_out_plug);
          ShowPlayer();
					//In FilePrefsRec lay Plugin options
				  break;
				case IDM_START2:
          HidePlayer();
          TOutputManagerRunInfo omri;
          omri.pJobList = &rs.vBatchList;
          if(rs.obOutputManager.Run(&omri))
          {
             DisableAllMenu();
             hDlg = CreateDialogParam( hInst, MAKEINTRESOURCE(IDD_PROGRESS), hWnd, 
                                         (DLGPROC)ProgressDlg, (LPARAM)&rs.obOutputManager); 
             InitDibDisplay(PPOST_WIDTH(rs.pp), PPOST_HEIGHT(rs.pp));
             ShowWindow( hDlg, SW_SHOW);
          }
          
					break;
				case IDM_PLAY:
          ShowPlayer();				
					break;
				case IDM_AUDIOPLAY:
          HidePlayer();
          if(rs.audio)
					  ShowAudioProperties();
          ShowPlayer();
					break;
				case IDM_OUTPUTCONFIG:
          HidePlayer();
					DialogBox(hInst, (LPCTSTR)IDD_OUTPUT_OPTIONS, hWnd, (DLGPROC)OutputOptionsDlg);
          SetTextMenu();
          ShowPlayer();
					break;
        case IDM_EXTRACTAUDIO:
          HidePlayer();
          ExportAudio();
          ShowPlayer();
          break;
				case IDM_ABOUT:
				   DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
				   break;
        case IDM_HOMEPAGE:
           ShellExecute(NULL, "open", "http://go.to/flaskmpeg", NULL, NULL, SW_SHOWNORMAL);
           break;
        case IDM_README:
          ShellExecute(NULL, "open", "./docs/readme.html", NULL, NULL, SW_SHOWNORMAL);
          break;          
				case IDM_EXIT:
           HidePlayer();
				   DestroyWindow(hWnd);
				   break;
				default:
				   return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		case WM_DROPFILES:
            HidePlayer();
            char dropFileName[MAXFILENAME];

            DragQueryFile( (HDROP)wParam, 0/*first file*/,dropFileName,MAXFILENAME); 


            if(OpenFile(dropFileName))
            {
              // clear jobs
              rs.vBatchList.clear();
              InsertFileInLastFilesList( rs.openedFileName );
              SetTextMenu();
              ShowPlayer();            
            }


            break;
    case WM_MOVE:
      // Snap the player at the botton of the main window
      if(rs.hPlayerWnd)
      {
        RECT rcMain;
        GetWindowRect( hMainWnd, &rcMain );
        WindowMove( rs.hPlayerWnd, rcMain.left, rcMain.bottom );
      }
      break;
		case WM_PAINT:
			hdc = BeginPaint(hWnd, &ps);
      rs.pVideoRenderer->Update();
			EndPaint(hWnd, &ps);
			break;
		case WM_DESTROY:
      o.options.selected_profile  = rs.profiler->GetSelectedIndex();
			o.options.selected_language = rs.lng->GetLanguage();
			o.options.outputFormat      = rs.selected_out_plug;
      
      rs.profiler->AddProfile(&rs.prof);

			SaveRegistryConfig(&o);
			FlushPluginSettings( &rs.plugs );
			ClosePlugins(&rs.plugs);
      StopMism();

      if( rs.video )
        delete rs.video;
      if( rs.audio )
        delete rs.audio;
      if( rs.pVideoRenderer )
        delete rs.pVideoRenderer;

			PostQuitMessage(0);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
   }
   return 0;
}

// Mesage handler for about box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
				SetText(hDlg, GS(ABOUT_TITLE) );
				DlgSetText( hDlg, R_ABOUT_GPL, GS(R_ABOUT_GPL) );
				DlgSetText( hDlg, R_ABOUT_TRANSLATOR, GS(R_ABOUT_TRANSLATOR) );
				DlgSetText( hDlg, R_ABOUT_DROPLINE, GS(R_ABOUT_DROPLINE) );
				DlgSetText( hDlg, R_ABOUT_ATHLON, GS(R_ABOUT_ATHLON) );

				return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}





