/* 
 *  FileOpen.cpp 
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#include "FlasKMPEG.h"
#include "RunState.h"
#include "error.h"
#include ".\Video\misc_tables.h"
#include ".\FileOpen.h"
#include ".\mism.h"
#include <string>

using namespace std;

extern TConfig   o;
extern TRunState rs;
extern HWND hMainWnd;
extern void EnableMenu();
extern void DisableMenu();
extern VBitmap				DecodedImage;
extern unsigned char		MPEGImage[MAX_IMAGE_MEM];
extern HINSTANCE hInst;
extern char          program_directory[MAX_PATH];

const char *GetFilterString()
{
  static string pFilter;
  string pExtensions;
  
  pFilter.empty();

  for( int j=0; j<rs.AvalInputs.GetCount(); j++ )
    pExtensions += rs.AvalInputs[j].sExtensions;
  
  pFilter = "Supported media files (";
  pFilter += pExtensions;
  pFilter += ")";
  
  pFilter.insert(pFilter.end(), 0);
  
  pFilter += pExtensions;
  pFilter.insert(pFilter.end(), 0);
  
  // All file types
  for( j=0; j<rs.AvalInputs.GetCount(); j++ )
  {
    pFilter += rs.AvalInputs[j].sDescription;
    pFilter += string(" (") + string(rs.AvalInputs[j].sExtensions) + string(")");
    pFilter.insert(pFilter.end(), 0);
    pFilter += rs.AvalInputs[j].sExtensions;
    pFilter.insert(pFilter.end(), 0);
  }
  
  pFilter += "All";
  
  pFilter.insert(pFilter.end(), 0);
  pFilter += "*.*";
  
  pFilter.insert(pFilter.end(), 0);

  return pFilter.c_str(); 
}

int OpenFile(char *inputFileName)
{
	OPENFILENAME oifn;
    char     InputFileBuffer[MAXFILENAME];
	char	*InputFile;


  InputFile = inputFileName;
  if(!inputFileName) //If no filename was specified open the open dialog box
  {
    // Initialize OPENFILENAME
    ZeroMemory(&oifn, sizeof(OPENFILENAME));
    oifn.lStructSize = sizeof(OPENFILENAME);
    oifn.hwndOwner = hMainWnd;
    strcpy(InputFileBuffer,"");
    oifn.lpstrFile = InputFileBuffer;
    oifn.nMaxFile = MAXFILENAME;
    oifn.lpstrFilter = GetFilterString();
    oifn.nFilterIndex = 1;
    oifn.lpstrFileTitle = "FlasKMPEG - Choose input stream file";
    oifn.nMaxFileTitle = 0;
    oifn.lpstrInitialDir = rs.prof.inputDir;
    oifn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
    if(!GetOpenFileName(&oifn))
	    	return 0;
    InputFile = InputFileBuffer;
  }


  // Disable menu. Enable it if everything went ok.
	DisableMenu();

  // First close streams if opened
  if( rs.pAudioMism.handle )
    rs.pAudioMism.pMismInfo->CloseStream( rs.pAudioMism.handle );
  if( rs.pVideoMism.handle )
    rs.pVideoMism.pMismInfo->CloseStream( rs.pVideoMism.handle );
  
  // and reset the handles
  rs.pAudioMism.handle = NULL;
  rs.pVideoMism.handle = NULL;

  // Try to find a mism that accepts this file
  int selectedMism = -1;

  DWORD nMerit, nMaxMerit = 0;
  // Pick the one with highest merit
  for( int i=0; i<rs.AvalInputs.GetCount(); i++ )
  {
    if (rs.AvalInputs[i].CanOpenFile( InputFile, &nMerit ) )
    {
      if(nMerit>=nMaxMerit)
      {
        selectedMism = i;
        nMaxMerit = nMerit;
      }
    }
  }

  if( selectedMism < 0 )
    return 0;

  // Now set the Misms for audio and video
  rs.pVideoMism.pMismInfo = &rs.AvalInputs[selectedMism];
  rs.pAudioMism.pMismInfo = &rs.AvalInputs[selectedMism];

  // Delete current audio and video decoders
  //  if any
  if(rs.audio){
	  delete rs.audio;
	  rs.audio=NULL;
  }
  if(rs.video){
	  delete rs.video;
	  rs.video=NULL;
  }

  fmStreamIds Ids;
  Ids.idCount = 0;
	//Now, we have to get the streams available in
  // this file.
  // Here it likely that the user will be presented 
  //   with a window to select streams.
  // That is handled by the Mism.
  // 
  // Use avalInput to get the streams.
  // Let's go.
  rs.AvalInputs[selectedMism].GetStreams( &Ids , InputFile );
  if( !Ids.idCount )
  {
    PrintError(UNS_FILE_OPEN,(int)hMainWnd, 0);
    return 0;
  }

  // Store iDs in rs
  rs.sStreamIds = Ids;

  //After recognizing type, you've obtained stream and substream
	//available
  fmStreamId videoId, audioId, spId;
  if( !GetFirstVideoId( &Ids, &videoId ) )
  {
	  PrintError(NO_VIDEO_TRACK,(int)hMainWnd, 0);
	  return 0;
  }
  // We got a video ID
  
  // And open the stream for the new working Mism
  if( !(rs.pVideoMism.handle = rs.pVideoMism.pMismInfo->OpenStream( InputFile ) ))
	  return 0;
  
  // Create video decoder
  rs.video = new VideoWrapper();
  
  TVideoInit sVideoInit;
  sVideoInit.pMismInfo          = &rs.pVideoMism;
  if(rs.pVideoMism.pMismInfo->dwReserved)
    sVideoInit.clut               = ((TExtraInfo *)rs.pVideoMism.pMismInfo->dwReserved)->clut;
  else
    sVideoInit.clut = 0;
  sVideoInit.nStreamId          = videoId.streamId;
  sVideoInit.nSubStreamId       = videoId.subStreamId;
  sVideoInit.nSubpicStreamId    = GetFirstSubpicId(&Ids, &spId) ? spId.streamId : -1;
  sVideoInit.nSubpicSubstreamId = GetFirstSubpicId(&Ids, &spId) ? spId.subStreamId : -1;
  sVideoInit.ProgramDirectory   = program_directory;

  // Initialize it. From now on, the video decoder will take full control of
  // this instance of the mism.
  if(!rs.video->Init(&sVideoInit))
  {
	  delete rs.video;
	  rs.video = NULL;
	  return 0;
  }

  // If we have audio
  int nIdx;
  if( GetFirstAudioId( &Ids, &audioId, &nIdx ) )
  {
    // If we have audio, the default one is indicated
    rs.sAudioTrack.nStreamId     = Ids.vIds[Ids.idAudioDef].streamId;
    rs.sAudioTrack.nSubStreamId  = Ids.vIds[Ids.idAudioDef].subStreamId;

    // And open the stream for the new working Mism
    if( ! (rs.pAudioMism.handle = rs.pAudioMism.pMismInfo->OpenStream( InputFile )) )
      return 0;
    rs.audio = new Audio();
    if(!rs.audio->Init(&rs.pAudioMism))
    {
      delete rs.audio; 
      rs.audio=NULL;
    }  
  }
  else
    rs.audio = NULL;
	
  switch(rs.video->detectedFrameRateCode){
  case 1:
    // HACK: LSX PLUGIN WANTS SCALE TO BE LIKE 2997/1000
    rs.prof.timeBase.scale=23976;
    rs.prof.timeBase.sampleSize=1000;
    break;
  case 2:
    rs.prof.timeBase.scale=24;
    rs.prof.timeBase.sampleSize=1;
    break;
  case 3:
    rs.prof.timeBase.scale=25;
    rs.prof.timeBase.sampleSize=1;
    break;
  case 4:
    rs.prof.timeBase.scale=2997;
    rs.prof.timeBase.sampleSize=100;
    break;
  case 5:
    rs.prof.timeBase.scale=30;
    rs.prof.timeBase.sampleSize=1;
    break;
  default:
    rs.prof.timeBase.scale=25;
    rs.prof.timeBase.sampleSize=1;
    break;
  }
  
  if(rs.audio)
  {
  	if( rs.audio->GetFormat()!=Ac3  &&  rs.audio->GetFormat()!=MpegAudio )
      rs.prof.audioMode=NO_AUDIO;
  }
  else
    rs.prof.audioMode=NO_AUDIO;

  // Modify profile values
  TMPGVideoInfo *pVideoInfo = rs.video->GetVideoInfo();
   
  rs.profiler->GetDefault()->timeBase.scale = 
     frame_rate_scale_table[pVideoInfo->detected_frame_rate_code];
   
  rs.profiler->GetDefault()->timeBase.sampleSize = 
     frame_rate_scale_samplesize[pVideoInfo->detected_frame_rate_code];
   
  rs.profiler->GetDefault()->timeBase.value = 0;
  if( pVideoInfo->detected_frame_rate_code == 1  &&
     pVideoInfo->frame_rate_code == 4 )
     rs.profiler->GetDefault()->recons_progressive = true;
  
  // Select the appropiate iDCT
  if(rs.prof.idctAutoSelect)
    // In case of auto select
    rs.profiler->GetDefault()->idctIndex = rs.video->GetIdctSelectedIndex();  
  else
    // SelectIdct returns the index of the Idct actually selected
    rs.profiler->GetDefault()->idctIndex  = rs.video->SelectIdct(rs.prof.idctIndex);




  // Copy opened file name to run state variable
  strcpy( rs.openedFileName, InputFile );

  //No error enable MENU
	EnableMenu();
  return 1;
}

