// Canvas.h: interface for the CCanvas class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CANVAS_H__47924CE9_2278_4596_A2B8_EBABA8A5F390__INCLUDED_)
#define AFX_CANVAS_H__47924CE9_2278_4596_A2B8_EBABA8A5F390__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <windows.h>

//uses 32 RGBA format
typedef unsigned __int32 Pixel32 ;
typedef unsigned __int32 Color32;

typedef struct TRectTag
{
  int nLeft;
  int nTop;
  int nRight;
  int nBottom;
} TRect;



// Origin is defined at top left. Increases downwards and to the right
#define RectWidth(x) (x.nRight - x.nLeft)
#define RectHeight(x) (x.nBottom - x.nTop)
#define FromRECTtoTRect(x)(  *( (TRect *)(&(x))  )  )
#define FromTRectToRECT(x)(  *( (RECT  *)(&(x))  )  )
#define MakeRect(x, top, left, bottom, right){ (x).nTop = top; (x).nLeft = left;  \
                                               (x).nBottom = bottom; (x).nRight = right; }
typedef struct TRectangleTag
{
  TRect   sRect;
  bool    bFilled;
  Color32 nColor;
  int     nBorder;
} TRectangle;

typedef struct TPosTag
{
  int nX;
  int nY;
} TPos;

class CCanvas  
{
public:

	CCanvas(HWND hWnd);
  virtual ~CCanvas(){ DeAlloc(); }
  void Alloc()
  {
    if(m_pCanvas)
      delete []m_pCanvas;
    m_pCanvas = new Pixel32[m_nWidth*m_nHeight];
  }
  void DeAlloc()
  {
    if(m_pCanvas)
      delete []m_pCanvas;
    m_pCanvas = NULL;
  }
  void DrawCanvas(int nXOffset, int nYOffset);
  void SetCanvasSize(int nWidth, int nHeight)
  {
    m_nWidth = nWidth;
    m_nHeight = nHeight;
  }

  void FillCollor(Color32 nColor)
  {
    for(int i=0;i<m_nWidth*m_nHeight;i++)
      m_pCanvas[i] = nColor;
  }

  void DrawRectangle(TRectangle *pRectangle)
  {
    int i,j;
    if( RectCheck(&pRectangle->sRect) )
    {
      if(pRectangle->bFilled)
      {
        for(i=pRectangle->sRect.nBottom;  i<pRectangle->sRect.nTop; i++)
          for(j=pRectangle->sRect.nLeft; j<pRectangle->sRect.nRight; j++)
            m_pCanvas[i*m_nWidth + j] = pRectangle->nColor;
      }      
      else
      {
        // border
        TRect rect = pRectangle->sRect;
        TRectangle sRectangle;
        sRectangle.bFilled = true;
        sRectangle.nColor  = pRectangle->nColor;
        sRectangle.nBorder = pRectangle->nBorder;

        // bottom
        sRectangle.sRect = rect;
        sRectangle.sRect.nTop = sRectangle.sRect.nBottom + sRectangle.nBorder;
        DrawRectangle(&sRectangle);
        // top
        sRectangle.sRect = rect;
        sRectangle.sRect.nBottom = sRectangle.sRect.nTop - sRectangle.nBorder;
        DrawRectangle(&sRectangle);
        // left
        sRectangle.sRect = rect;
        sRectangle.sRect.nRight = sRectangle.sRect.nLeft + sRectangle.nBorder;
        DrawRectangle(&sRectangle);
        // right
        sRectangle.sRect = rect;
        sRectangle.sRect.nLeft = sRectangle.sRect.nRight - sRectangle.nBorder;
        DrawRectangle(&sRectangle);
        
      }
    }
  }

protected:
  bool RectCheck(TRect *pRect)
  {
    if((pRect->nLeft + RectWidth((*pRect))) > m_nWidth )
      return false;
    if((pRect->nTop + RectHeight((*pRect))) > m_nHeight )
      return false;
    return true;
  }
  Pixel32 *m_pCanvas;
  int     m_nWidth, m_nHeight; // Canvas size
  HWND  m_hDrawWnd;  
private:

  BITMAPINFO m_sBmpInfo;


};

#endif // !defined(AFX_CANVAS_H__47924CE9_2278_4596_A2B8_EBABA8A5F390__INCLUDED_)
