// Canvas.cpp: implementation of the CCanvas class.
//
//////////////////////////////////////////////////////////////////////

#include "Canvas.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

const int nMaxCanvasSize = 256;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CCanvas::CCanvas(HWND hWnd)
{
  m_hDrawWnd = hWnd;
  m_nHeight = m_nWidth = nMaxCanvasSize;
  m_pCanvas = NULL;
  memset( &m_sBmpInfo, 0, sizeof(BITMAPINFO) );
  m_sBmpInfo.bmiHeader.biSize       = sizeof(BITMAPINFO);
  m_sBmpInfo.bmiHeader.biBitCount   = 32;
  m_sBmpInfo.bmiHeader.biWidth      = nMaxCanvasSize;
  m_sBmpInfo.bmiHeader.biHeight     = nMaxCanvasSize;
  m_sBmpInfo.bmiHeader.biPlanes     = 1;
  m_sBmpInfo.bmiHeader.biCompression= BI_RGB;
  Alloc();
}

void CCanvas::DrawCanvas(int nXOffset, int nYOffset)
{
  HDC hDC = GetDC(m_hDrawWnd);
  SetDIBitsToDevice((HDC) hDC,nXOffset,nYOffset,m_nWidth,m_nHeight,
    0,0,0,m_nWidth, m_pCanvas ,&m_sBmpInfo, DIB_RGB_COLORS);
  ReleaseDC( m_hDrawWnd, (HDC)hDC);
}