/* 
 *  Auxiliary.h
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#ifndef AUX_H
#define AUX_H

HWND CreateNormalWindow(WNDPROC WndProc, HINSTANCE hInstance, HWND hParent);
void WindowMove(HWND window, int x, int y);
void WindowShow(HWND hWnd);
void WindowHide(HWND hWnd);
void WindowResize(HWND window, int w, int h);
void WindowClientResize(HWND window, int w, int h);

void MenuCheck(HWND hWnd, int item);
void MenuUnCheck(HWND hWnd, int item);
void MenuEnable(HWND hWnd, int item);
void MenuAddItem(HMENU hMenu,int item ,int wID, char *text);
void MenuAddSeparator(HMENU hMenu,int item );
void MenuDisable(HWND hWnd, int item);
void MenuSetText(HMENU hMenu,int item ,char *text );
HMENU MenuGetPopup( HMENU hMenu, int item );

void SetText(HWND hWnd, char *text);

void TabSetText(HWND hTab, int item, char *text);

void DlgCheck(HWND hDlg, int item, bool check);
void DlgCheck(HWND hDlg, int item);
void DlgUnCheck(HWND hDlg, int item);

bool DlgIsChecked(HWND hDlg, int item);

void DlgEnable(HWND hDlg, int item, bool enable);
void DlgEnable(HWND hDlg, int item);
void DlgDisable(HWND hDlg, int item);
void DlgSetFocus(HWND hDlg, int control);
int DlgGetInt(HWND hDlg, int item);

int DlgGetText( HWND hDlg, int item);
char *DlgGetText( HWND hDlg, int item, char* text);
void DlgSetText(HWND hDlg, int item, int number);
void DlgSetText(HWND hDlg, int item, char* text);
void DlgSetDouble(HWND hDlg, int item, double number);
void DlgCheckBoxState(HWND hDlg, int item, int state);

int GetOutputFileName(HWND hWnd, char* fileName, char* Dir, char* Title);

//LIST BOXES
void ListAddText(HWND list, char *text);
int ListGetCur(HWND list);
void ListSetCur(HWND list, int cur);
void ListClean(HWND list);

void MillisecondsToTime( char *str, DWORD time);
void LocalTimePlusMilliseconds(char *str, DWORD msec, bool show_seconds);
void StringFrameRate(int fr, char *sFrameRate);
#endif