#include "FlasKMPEG.h"
#include "auxiliary.h"
#include "resource.h"
#include "AudioPlayer.h"
#include "Audio/AudioPlayback.h"
#include "./Misc/StatsStrings.h"
#include "./Video/VideoWrapper.h"
#include "./RunState.h"



// Extern globals
extern TConfig          o;
extern TRunState        rs;
extern HINSTANCE        hInst;
extern unsigned char    MPEGImage[MAX_IMAGE_MEM];
extern unsigned char    DisplayImage[MAX_IMAGE_MEM];
extern VBitmap			Display;
extern VBitmap			DecodedImage;
extern HWND				hMainWnd;
extern BITMAPINFO		DibInfo;
extern BOOL             playerStopped; //Needed for main window to redraw

// local variables
static HWND                 hPlayerDlg;
static HANDLE               evPlayerStopped; 
static HANDLE               evFrameCaptured;
static CRITICAL_SECTION     GlobalCriticalSection; 
static bool                 SeekInProgress;
static i64		             diferencia;
static bool audioplayer_quiet = false;

// from the ac3dec code. This needs to be cleaned up!
extern "C" { 
	extern int m_gainlevel; 
	extern int m_gain2level;
	extern int m_gaincenter;
	extern int m_gainrear;
	extern int m_gainlfe;
	extern float GAINSCALE;
	extern int m_do_normalize;
	void ac3_clear_normalize();
	void ac3_get_normalize(int *min, int *max);
}

// converts from ac3config struct to internal (ac3dec downmixer) ints 
void SetAC3Config(AC3Config* ac3config)
{
	m_gainlevel = ac3config->gainlevel;
	m_gain2level = ac3config->gain2level;
	m_gaincenter = ac3config->gaincenter;
	m_gainrear = ac3config->gainrear;
	m_gainlfe = ac3config->gainlfe;
	GAINSCALE = ac3config->gainscale;
	if ((GAINSCALE < 32000) || (GAINSCALE > 120000)) GAINSCALE = 32700; //sane
}

DWORD WINAPI  AudioPlayerThread(LPVOID *nada){

	/*
HDC hDC;
static unsigned char newblock[MAX_IMAGE_MEM];
	static i64 prevTime;
	static presInfo pInfo;
	YUVImageTag  *frame;
*/
					TAudioPlayback ap;
					unsigned char *data;

					ap.n_channels = 2;
					if (rs.prof.sampleFreqSameAsInput)
						ap.sample_freq = rs.audio->sampleRate;
					else
						ap.sample_freq = rs.prof.outSampleFrequency; 
					ap.chunk_size = 4096*6;
					

				    AudioPlaybackStart(&ap);
					//rs.audio->Start(rs.audio->sampleRate, 0, DO_AUDIO);
					rs.audio->Start(ap.sample_freq, DO_AUDIO);
					while(1)
					{
						if (rs.video->stopDecoding==true) {
							AudioPlaybackStop(&ap);
							SetEvent(evPlayerStopped);
							return 0;
						}
						rs.audio->GetSamples(0, (short **)&data, (4096*6)>>2);
						OutputDebugString("starting write");
						if (! audioplayer_quiet)
							AudioPlaybackWrite(&ap, data);
						OutputDebugString("ending write");
						SetEvent(evFrameCaptured);

					}
					return 0;
}
#if 0
TAudioPlayback ap;
unsigned char *data;

ap.n_channels = 2;
ap.sample_freq = rs.audio->sampleRate;
ap.chunk_size = 4096*6;



AudioPlaybackStart(&ap);
rs.audio->Start(rs.audio->sampleRate, 0, DO_AUDIO);
while(1)
{
  rs.audio->GetSamples(0, (short **)&data, (4096*6)>>2);
  OutputDebugString("starting write");
  AudioPlaybackWrite(&ap, data);
  OutputDebugString("ending write");
}
AudioPlaybackStop(&ap);
#endif

LRESULT CALLBACK AudioPlayerDlg(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	static HANDLE hPlayer;
	DWORD PlayerIDThread;
	static int playerTimer;
	char szTemp[256];
	//int fPosition, lPosition;
	static bool userIsTracking;
	TVideoOptions video_opt;
	static int kkk;
	bool doNothing;
	static bool do_seek_first;
	static float norm_suggestion=0;

	switch (message)
	{

		case WM_TIMER:
			if( playerStopped || userIsTracking || SeekInProgress ) // don't bother
				break; 
			SendDlgItemMessage(hDlg, IDC_SLIDER, TBM_SETPOS, TRUE, 
					(long)(1000.0*(double((i64)rs.audio->GetStreamPos()) /
								   double((i64)rs.audio->GetStreamSize())) ) ); 
			int min, max, ampl;
			ac3_get_normalize(&min, &max);
			DlgSetText(hDlg, IDC_NORM_MIN, min);
			DlgSetText(hDlg, IDC_NORM_MAX, max);
			ampl = abs(min); 
			if (max > ampl) ampl = max;
			if (ampl > 0) {
				// 5% safety margin (0.95)
				norm_suggestion = 0.95f * 32767.0f*GAINSCALE/float(ampl);
				DlgSetText(hDlg, IDC_NORM_SUGG, (int)norm_suggestion);
				DlgEnable(hDlg, IDC_NORM_APPLY);
			}
			else {
				DlgSetText(hDlg, IDC_NORM_SUGG, "N/A");
				DlgDisable(hDlg, IDC_NORM_APPLY);
			}
			break;
/*
			// time
			MillisecondsToTime(szTemp, rs.video->time);
			SetDlgItemText(hDlg, IDC_PLAYTIME, szTemp);
			// Total frames
			// File
			DlgSetText(hDlg, IDC_FILE, rs.video->GetVideoFileName());
			// Total file size
			sprintf( szTemp, "%d Mbytes", rs.video->GetVideoSize()/(1024*1024));
			SetDlgItemText(hDlg, IDC_FILESIZE, szTemp);
			// Video size
			DlgSetText(hDlg,IDC_VIDEOSIZE ,rs.video->sVideoSize);
			// Frame rate
			DlgSetText(hDlg,IDC_FRAMERATE ,rs.video->sFrameRate);
			//Detected FPS
			DlgSetText(hDlg,IDC_DETECTEDFPS ,rs.video->sDetectedFPS);
			// Aspect Ratio
			DlgSetText(hDlg,IDC_ASPECTRATIO ,rs.video->sAspectRatio);
			// Bitrate
			DlgSetText(hDlg,IDC_BITRATE ,rs.video->sBitrate);
			// Progressive sequence
			DlgSetText(hDlg,IDC_PROGRESSIVE ,rs.video->sProgressive);
			//DlgSetText(hDlg,IDC_PROGRESSIVE ,video->internalPTS/27000.0);
			//DlgSetText(hDlg,IDC_BITRATE ,diferencia);
			fPosition=true;
			lPosition= (int)(((double)(rs.video->GetVideoPos())/(double)(rs.video->GetVideoSize()))*1000);
			if( !userIsTracking && !SeekInProgress )
				SendDlgItemMessage(hDlg, IDC_SLIDER, TBM_SETPOS, (WPARAM) (BOOL) fPosition,(LPARAM) (LONG) lPosition); 
			break;
*/
		case WM_INITDIALOG:
			//myClock=0;
			//frameSpan= (i64)((1/((double)(o.options.timeBase.scale)/
			//		 (double)(o.options.timeBase.sampleSize)))*(double)MPEG2_CLK_REF);
			// Initialize the critical section.
			InitializeCriticalSection(&GlobalCriticalSection);

			// set audio info text
			if (rs.audio->isAC3) {
				TAudioInfo* info = rs.audio->GetAudioInfo();
				sprintf(szTemp, "Audio input AC3, %d Hz, %d kbit/s, %d channels; output %d Hz, 2 channels", 
					info->sample_rate, info->bit_rate, info->channels, 
					(rs.prof.sampleFreqSameAsInput ? rs.audio->sampleRate :	rs.prof.outSampleFrequency));
			}
			else {
				sprintf(szTemp, "Audio: MPEG stream; output %d Hz, 2 channels",
					(rs.prof.sampleFreqSameAsInput ? rs.audio->sampleRate :	rs.prof.outSampleFrequency));
			}
			DlgSetText(hDlg, IDC_AUDIO_INFO, szTemp);

			do_seek_first = true; // seek beginning of video when play is pressed
/*			
			// Get post processing options from config
			GetPPostConfig(&o, &rs.pp);
			// Set additional parameters
			rs.pp.iDAR = rs.video->DAR;
			InitDibDisplay(PPOST_WIDTH(rs.pp) , PPOST_HEIGHT(rs.pp));

			DecodedImage.init(&MPEGImage, rs.video->pictureWidth, rs.video->picutreHeight, 32);
			DecodedImage.AlignTo4();
			// Start Post processing
			PostProcessingStart(&DecodedImage, &Display, &rs.pp);
*/
			
			audioplayer_quiet = false;
			m_do_normalize = true;
      

      hPlayerDlg=hDlg;
      SeekInProgress=false;
			userIsTracking=false;
						EnableWindow( GetDlgItem(hDlg, IDC_PLAY), true); 
						EnableWindow( GetDlgItem(hDlg, IDOK), true); 
						EnableWindow( GetDlgItem(hDlg, IDC_SEEKFIRST), true); 
						EnableWindow( GetDlgItem(hDlg, IDC_SLIDER), false); 
						EnableWindow( GetDlgItem(hDlg, IDC_STOP), false); 
			SendDlgItemMessage(hDlg, IDC_SLIDER, TBM_SETRANGE, (WPARAM) TRUE,(LPARAM) MAKELONG(0, 1000)); 
			SendDlgItemMessage(hDlg, IDC_SLIDER1, TBM_SETRANGE, (WPARAM) TRUE,(LPARAM) MAKELONG(0, 500)); 
			SendDlgItemMessage(hDlg, IDC_SLIDER2, TBM_SETRANGE, (WPARAM) TRUE,(LPARAM) MAKELONG(0, 500)); 
			SendDlgItemMessage(hDlg, IDC_SLIDER3, TBM_SETRANGE, (WPARAM) TRUE,(LPARAM) MAKELONG(0, 500)); 
			SendDlgItemMessage(hDlg, IDC_SLIDER4, TBM_SETRANGE, (WPARAM) TRUE,(LPARAM) MAKELONG(0, 500)); 
			SendDlgItemMessage(hDlg, IDC_SLIDER5, TBM_SETRANGE, (WPARAM) TRUE,(LPARAM) MAKELONG(0, 500)); 
			SendDlgItemMessage(hDlg, IDC_NORM_SLIDER, TBM_SETRANGE, (WPARAM) TRUE,(LPARAM) MAKELONG(0, 32000)); 

			SendDlgItemMessage(hDlg, IDC_SLIDER, TBM_SETPOS, TRUE, 
					(long)(1000.0*(double((i64)rs.startFilePos) /
								   double((i64)rs.audio->GetStreamSize())) ) ); 
			SendDlgItemMessage( hDlg, IDC_SLIDER1, TBM_SETPOS, TRUE, (ui32)(500-m_gainlevel) );
			sprintf(szTemp, "%d", m_gainlevel);
			DlgSetText(hDlg, IDC_STATIC1, szTemp);
			SendDlgItemMessage( hDlg, IDC_SLIDER2, TBM_SETPOS, TRUE, (ui32)(500-m_gain2level) );
			sprintf(szTemp, "%d", m_gain2level);
			DlgSetText(hDlg, IDC_STATIC2, szTemp);

			if (m_gaincenter < 1000) {
				SendDlgItemMessage( hDlg, IDC_SLIDER3, TBM_SETPOS, TRUE, (ui32)(500-m_gaincenter) );
				sprintf(szTemp, "%d", m_gaincenter);
				DlgSetText(hDlg, IDC_CHECK1, szTemp);
				DlgCheck(hDlg, IDC_CHECK1);
			}
			else { // disabled; set slider to zero
				SendDlgItemMessage( hDlg, IDC_SLIDER3, TBM_SETPOS, TRUE, (ui32)500 );
				DlgSetText(hDlg, IDC_CHECK1, "0");
				DlgUnCheck(hDlg, IDC_CHECK1);
			}
			if (m_gainrear < 1000) {
				SendDlgItemMessage( hDlg, IDC_SLIDER4, TBM_SETPOS, TRUE, (ui32)(500-m_gainrear) );
				sprintf(szTemp, "%d", m_gainrear);
				DlgSetText(hDlg, IDC_CHECK2, szTemp);
				DlgCheck(hDlg, IDC_CHECK2);
			}
			else {
				SendDlgItemMessage( hDlg, IDC_SLIDER4, TBM_SETPOS, TRUE, (ui32)500 );
				DlgSetText(hDlg, IDC_CHECK2, "0");
				DlgUnCheck(hDlg, IDC_CHECK2);
			}
			if (m_gainlfe < 1000) {
				SendDlgItemMessage( hDlg, IDC_SLIDER5, TBM_SETPOS, TRUE, (ui32)(500-m_gainlfe) );
				sprintf(szTemp, "%d", m_gainlfe);
				DlgSetText(hDlg, IDC_CHECK3, szTemp);
				DlgCheck(hDlg, IDC_CHECK3);
			}
			else {
				SendDlgItemMessage( hDlg, IDC_SLIDER5, TBM_SETPOS, TRUE, (ui32)500 );
				DlgSetText(hDlg, IDC_CHECK3, "0");
				DlgUnCheck(hDlg, IDC_CHECK3);
			}

			SendDlgItemMessage(hDlg, IDC_NORM_SLIDER, TBM_SETPOS, TRUE, (LPARAM)(GAINSCALE/4));
			DlgSetText(hDlg, IDC_NORM_CURR, (int)GAINSCALE);
			DlgDisable(hDlg, IDC_NORM_APPLY);
			DlgSetText(hDlg, IDC_NORM_SUGG, "N/A");

			evPlayerStopped=CreateEvent(NULL, TRUE, FALSE,NULL);
			evFrameCaptured=CreateEvent(NULL, TRUE, FALSE,NULL);
			

			playerTimer= SetTimer(hDlg,              // handle of window for timer messages
								     3,          // timer identifier
								   500,           // time-out value
								   NULL   // address of timer procedure
								   );

				return TRUE;
		case WM_HSCROLL:
			int nPos;
			if (GetDlgItem(hDlg, IDC_SLIDER) == (HWND)lParam) {
			switch(LOWORD(wParam)){
				case TB_THUMBTRACK:
					userIsTracking = true;
					break;

				case TB_THUMBPOSITION :

				//Disable trackbar
				EnterCriticalSection(&GlobalCriticalSection);
					if(SeekInProgress)
						doNothing=true;
					else{

						doNothing=false;
					}
				LeaveCriticalSection(&GlobalCriticalSection);
				if(doNothing) return 0;
				
				SeekInProgress=true;
				DlgDisable(hDlg, IDC_SLIDER);
				nPos = SendDlgItemMessage(hDlg, IDC_SLIDER, TBM_GETPOS, 0, 0);   
				//Stopvideo
					ResetEvent(evPlayerStopped);
					rs.video->stopDecoding=true;
					WaitForSingleObject(evPlayerStopped, 5000);
					CloseHandle(hPlayer);
					rs.video->Stop();
/*
					if(rs.audio)
						if(o.options.audioMode==DSC)
							rs.audio->Stop();
*/
				//Seek
					rs.startFilePos=(i64)(((double)nPos/1000.0)*(double)((i64)rs.video->GetStreamSize()));
					rs.video->SetStreamPos(rs.startFilePos);
					if(rs.audio)
						rs.audio->SetStreamPos(rs.startFilePos);
				//
				video_opt.idctIndex            = rs.prof.idctIndex;
				video_opt.recons_progressive   = rs.prof.recons_progressive;
        video_opt.bStartInSync         = false;
				//myClock=0;
				rs.video->Start(&video_opt);
/*
				if(rs.audio)
					if(o.options.audioMode==DSC)
						rs.audio->Start(o.options.audioOutFile, o.options.audioMode);
*/
				hPlayer=CreateThread(NULL,0,(LPTHREAD_START_ROUTINE) AudioPlayerThread,(LPVOID)NULL,0,&PlayerIDThread);  
				ResetEvent(evFrameCaptured);
				WaitForSingleObject(evFrameCaptured, 5000);
				userIsTracking=false;
				SeekInProgress=false;		//if we were seeking
				EnableWindow( GetDlgItem(hDlg, IDC_SLIDER), true); 
				break;
			}
			}
			else if (GetDlgItem(hDlg, IDC_NORM_SLIDER) == (HWND)lParam) {
				ac3_clear_normalize();
				unsigned int gainscale;
				gainscale = 4*SendDlgItemMessage(hDlg, IDC_NORM_SLIDER, TBM_GETPOS, 0,0);
				DlgSetText( hDlg, IDC_NORM_CURR, gainscale);
				GAINSCALE = (float)gainscale;
			}
			break;
		case WM_VSCROLL:
			int tmp;
			//if (LOWORD(wParam) == TB_THUMBPOSITION) 
			m_gainlevel = 500-SendDlgItemMessage(hDlg, IDC_SLIDER1, TBM_GETPOS, 0, 0);
			sprintf(szTemp, "%d", m_gainlevel);
			DlgSetText( hDlg, IDC_STATIC1, szTemp );
			m_gain2level = 500-SendDlgItemMessage(hDlg, IDC_SLIDER2, TBM_GETPOS, 0, 0);
			sprintf(szTemp, "%d", m_gain2level);
			DlgSetText( hDlg, IDC_STATIC2, szTemp );
			tmp = 500-SendDlgItemMessage(hDlg, IDC_SLIDER3, TBM_GETPOS, 0, 0);
			sprintf(szTemp, "%d", tmp);
			DlgSetText( hDlg, IDC_CHECK1, szTemp );
			if (DlgIsChecked(hDlg, IDC_CHECK1))
				m_gaincenter = tmp;
			tmp = 500-SendDlgItemMessage(hDlg, IDC_SLIDER4, TBM_GETPOS, 0, 0);
			sprintf(szTemp, "%d", tmp);
			DlgSetText( hDlg, IDC_CHECK2, szTemp );
			if (DlgIsChecked(hDlg, IDC_CHECK2))
				m_gainrear = tmp;
			tmp = 500-SendDlgItemMessage(hDlg, IDC_SLIDER5, TBM_GETPOS, 0, 0);
			sprintf(szTemp, "%d", tmp);
			DlgSetText( hDlg, IDC_CHECK3, szTemp );
			if (DlgIsChecked(hDlg, IDC_CHECK3))
				m_gainlfe = tmp;
			break;
		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
			{
				CloseHandle(evPlayerStopped);
				CloseHandle(evFrameCaptured);

				m_do_normalize = 0;
/*				
				PostProcessingStop(&rs.pp);
*/
				KillTimer( hDlg, 3);
/*
				SetWindowSize();
*/
				ac3config.version = 0;
				ac3config.gainlevel = m_gainlevel;
				ac3config.gain2level = m_gain2level;
				ac3config.gaincenter = m_gaincenter;
				ac3config.gainrear = m_gainrear;
				ac3config.gainlfe = m_gainlfe;
				ac3config.gainscale = GAINSCALE;
				SaveRegistryAC3Config(&ac3config);

				InvalidateRect(hMainWnd, NULL, true);
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			switch( LOWORD(wParam)){
				case IDC_CHECK1:
					if (DlgIsChecked(hDlg, IDC_CHECK1))
						m_gaincenter = 500-SendDlgItemMessage(hDlg, IDC_SLIDER3, TBM_GETPOS, 0, 0);
					else
						m_gaincenter = 1000;
					break;
				case IDC_CHECK2:
					if (DlgIsChecked(hDlg, IDC_CHECK2))
						m_gainrear = 500-SendDlgItemMessage(hDlg, IDC_SLIDER4, TBM_GETPOS, 0, 0);
					else
						m_gainrear = 1000;
					break;
				case IDC_CHECK3:
					if (DlgIsChecked(hDlg, IDC_CHECK3))
						m_gainlfe = 500-SendDlgItemMessage(hDlg, IDC_SLIDER5, TBM_GETPOS, 0, 0);
					else
						m_gainlfe = 1000;
					break;
				case IDC_NORMALIZE:
					if (DlgIsChecked(hDlg, IDC_NORMALIZE)) 
						audioplayer_quiet = true;
					else
						audioplayer_quiet = false;
					break;
				case IDC_NORM_APPLY:
					GAINSCALE = norm_suggestion;
					ac3_clear_normalize();
					SendDlgItemMessage(hDlg, IDC_NORM_SLIDER, TBM_SETPOS, TRUE, (LPARAM)((int)(GAINSCALE/4)));
					DlgSetText(hDlg, IDC_NORM_CURR, (int)GAINSCALE);
					break;
				case IDC_NORM_RESET:
					ac3_clear_normalize();
					break;
				case IDC_SEEKFIRST:
					rs.startFilePos=0;
					rs.video->SetStreamPos(rs.startFilePos);
					if(rs.audio)
						rs.audio->SetStreamPos(rs.startFilePos);
				break;
				case IDC_PLAY:
						playerStopped=false;
						//Grey PLAY AND EXIT
						EnableWindow( GetDlgItem(hDlg, IDC_PLAY), false); 
						EnableWindow( GetDlgItem(hDlg, IDOK), false); 
						EnableWindow( GetDlgItem(hDlg, IDC_SEEKFIRST), false); 
						EnableWindow( GetDlgItem(hDlg, IDC_SLIDER), true); 
						EnableWindow( GetDlgItem(hDlg, IDC_STOP), true); 

						if (do_seek_first) { // first time playing for this dialog
							do_seek_first = false;
							// Seek video
							rs.video->SetStreamPos(rs.startFilePos);
							if(rs.audio)
								rs.audio->SetStreamPos(rs.startFilePos);
						}

						video_opt.idctIndex            = rs.prof.idctIndex;
						video_opt.recons_progressive   = rs.prof.recons_progressive;
            video_opt.bStartInSync         = false;
						//myClock=0;
						rs.video->Start(&video_opt);
/*
						if(rs.audio)
							if(o.options.audioMode==DSC)
								rs.audio->Start(o.options.audioOutFile, o.options.audioMode);
*/
			
						hPlayer=CreateThread(NULL,0,(LPTHREAD_START_ROUTINE) AudioPlayerThread,(LPVOID)NULL,0,&PlayerIDThread);  
					break;
				case IDC_STOP:

						EnableWindow( GetDlgItem(hDlg, IDC_SLIDER), false); 
						EnableWindow( GetDlgItem(hDlg, IDC_STOP), false); 
						
						ResetEvent(evPlayerStopped);
						rs.video->stopDecoding=true;
						WaitForSingleObject(evPlayerStopped, 5000);
						
						CloseHandle(hPlayer);
						rs.video->Stop();
						rs.startFilePos = rs.audio->GetStreamPos();
/*
						if(rs.audio)
							if(o.options.audioMode==DSC)
								rs.audio->Stop();
*/
						EnableWindow( GetDlgItem(hDlg, IDC_PLAY), true); 
						EnableWindow( GetDlgItem(hDlg, IDOK), true);
						EnableWindow( GetDlgItem(hDlg, IDC_SEEKFIRST), true); 
						playerStopped=true;
					break;
			}
			break;
	}
    return FALSE;
}
